#include <string.h>
#include <stdlib.h>
#include "rtos.h"
#include "HTTPClient.h"

#include "system.h"
#include "yodiwo_api.h"




typedef void * (*thread_func)(void *);

typedef struct thread_info_s
{
    Thread *t;
    thread_func func;
    void *args;
    void *result;
} thread_info;

void __thread_wrapper(void const *args);

HTTPClient http;

int thread_run(thread_t *ctx, thread_func func, void * args, int priority, int stack_size)
{
    thread_info *info = (thread_info *)malloc(sizeof(thread_info));
    if (info == NULL) {
        return -1;
    }    
    *ctx = info;
    info->func = func;
    info->args = args;
    info->result = NULL;

    if (stack_size) {
        (*ctx)->t = new Thread(__thread_wrapper, *ctx, (osPriority)priority, stack_size);
    } else {
        (*ctx)->t = new Thread(__thread_wrapper, *ctx, (osPriority)priority);
    }
    return 0;
}

void __thread_wrapper(void const *args)
{
    thread_info *info = (thread_info *)args;
    info->result = info->func(info->args);
    return;
}

void thread_wait(int ms)
{
    Thread::wait(ms);
}

void *thread_join(thread_t *ctx)
{
    while ((*ctx)->t->get_state() != Thread::Inactive) {
//        printf("yielding... %d\n", t.get_state());
//        Thread::yield();
//        Thread::wait(1000);
    }
    return (*ctx)->result;
}

int http_post(char *url, char *post_fields, char *response, size_t max_size)
{
    http.dumpReqHeader(true);
    http.dumpResHeader(true);
    int ret;
        //POST data
    HTTPText params(post_fields, strlen(post_fields) + 1);
    params.setDataType("application/x-www-form-urlencoded");
    HTTPText inText(response, max_size);
    printf("\nTrying to post data...\n");
    printf("post url: %s\n", url);
    ret = http.post(url, params, &inText);
    if (!ret) {
        ret = http.getHTTPResponseCode();
    }
    return ret;
}

