#ifndef SYSTEM_H_
#define SYSTEM_H_


#ifdef __cplusplus
extern "C" {
#endif

typedef void * (*thread_func)(void *);


#ifdef linux

#include <pthread.h>
typedef pthread_t thread_t;

#elif defined(__MBED__)


//
//#ifdef __cplusplus
//#include "rtos.h"
//#else
//struct Thread;
//#endif
//
////#include "mbed.h"
////struct thread_s;
typedef struct thread_info_s* thread_t;
#endif


/*
 * These functions must be implemented for the node platform
 * for linux, thread_* functions are wrappers for pthead functions
 * and http_post uses curl to do an http post and return the response code and body to the caller
 * implementation is in system_linux.c
 */

int thread_run(thread_t *ctx, thread_func func, void * args, int priority, int stack_size);
void thread_wait(int ms);
void *thread_join(thread_t *ctx);

int http_post(char *url, char *post_fields, char *response, size_t max_size);


#ifdef __cplusplus
}
#endif

#endif /* SYSTEM_H_ */

