#include "EthernetInterface.h"
#include "HTTPD.h"
#include "string.h"
#include "pairing_backend.h"
#include "pairing_http_handler.h"

HTTPD *httpd;
pairing_context pairing_state;
onPaired_callback pairing_done_cb;
EthernetInterface *interface;
void pairing_handler (int id);
int server_port; //TODO: get this from HTTPD?


int startpairing(int id);
int next(int id);

int start_pairing_http_server(void *ifdata, int port, onPaired_callback onPaired)
{
    interface = (EthernetInterface *)ifdata;
    pairing_done_cb = onPaired;
    httpd = new HTTPD;
//    httpd->attach("/cgi-bin/", &callback_cgi);
//    httpd->attach("/ws/", &callback_ws);
    httpd->attach("/pairing/", &pairing_handler);
    httpd->attach("/", "/sd/www/");
    return httpd->start(port);
}

void pairing_handler (int id)
{
    if (!strcmp(httpd->getFilename(id), "startpairing")) {
        if (!startpairing(id)) {
            return;
        }
    } else if (!strcmp(httpd->getFilename(id), "next")) {
        if (!next(id)) {
            return;
        }

    } else {
        httpd->httpdError(id, 404);
    }
    httpd->httpdError(id, 400);
}

int startpairing(int id)
{
    char urlBase[100];
    int i;
    printf("starting pairing...\n");
    pairing_context_init_from_config(&pairing_state, pairing_done_cb);
    pairing_get_tokens(&pairing_state);
    
    int idx = 0;
    i = 0;
    char *uri = httpd->getUri(id);
    while (uri[i] != '\0') {
        if (uri[i] == '/') {
            idx = i;
        }
        i++;
    }
    urlBase[0] = '\0';
    strncat(urlBase, uri, idx + 1);
    char *redirect = get_server_phase2_url(&pairing_state, interface->getIPAddress(), server_port, urlBase);
    printf("redirect url: %s\n", redirect);
    if (redirect) {
        httpd->redirect(id, 302, redirect, NULL, 0, NULL);
        free(redirect);
        return 0;
    }
    return -1;
}

int next(int id)
{
    char buf[300];
    int ret;
    ret = pairing_get_keys(&pairing_state);
    if (ret) {
        return ret;
    }
    pairing_done_cb(pairing_state.nodeKey, pairing_state.secretKey);
    sprintf(buf, "OK\r\nnodeKey: %s\r\nsecretKey: %s\r\n", pairing_state.nodeKey, pairing_state.secretKey);
    httpd->send(id, buf, strlen(buf), "Content-Type: text/plain\r\n");
    return 0;
}
