#ifndef __YOPLEGMA_THINGS_H__
#define __YOPLEGMA_THINGS_H__

#include "MQTTClient.h"
#include "MQTTSocket.h"

#include "yodiwo_api.h"
#include <stdlib.h>

#define MAX_MSG_LEN 2500
#define MAX_TOPIC_LEN 150


typedef int (func_ToJson)(char *, size_t, void *);
typedef Yodiwo_Plegma_Json_e (func_FromJson)(char *, size_t, void *);

int mqtt_init(char *hostname, int port, char *certfile, char *nodeKey, char *nodeSecret);
void on_mqtt_message(MQTT::MessageData &msg);

int button_event(int buttonId, bool pressed);

typedef int (*portevent_handler_func)(Yodiwo_Plegma_PortEvent_t *event);

void initialize_things(char *nodeKey);
int publisher(char *msg, int msg_len, char *msg_type);


int handle_red_led(Yodiwo_Plegma_PortEvent_t *event);
int handle_green_led(Yodiwo_Plegma_PortEvent_t *event);
int handle_blue_led(Yodiwo_Plegma_PortEvent_t *event);

extern Array_Yodiwo_Plegma_Thing_t things;

void register_led_handlers();

void axel_thread(const void *args);

#endif /* __YOPLEGMA_THINGS_H__ */
