#include "mbed.h"
#include "rtos.h"

#include <stdint.h>

#include "yoplegma_things.h"
#include "yodiwo_functions.h"
#include "jsmn.h"
#include "yodiwo_api.h"
#include "yodiwo_helpers.h"

///////////////////////////////// LEDS
DigitalOut redled(LED1);
DigitalOut greenled(LED2);
DigitalOut blueled(LED3);

///////////////////////////////// THINGS
Yodiwo_Plegma_Port_t button_port;
Yodiwo_Plegma_Port_t axel_port;
Yodiwo_Plegma_Port_t _led_ports[3];

Yodiwo_Plegma_Thing_t *button;
Yodiwo_Plegma_Thing_t *axel;
Yodiwo_Plegma_Thing_t *led;

Yodiwo_Plegma_Thing_t _things[3];
Array_Yodiwo_Plegma_Thing_t things;


int shaken_event()
{
    Yodiwo_Plegma_PortEvent_t event;
    Array_Yodiwo_Plegma_PortEvent_t array_events;
    
    event.PortKey = axel->Ports.elems[0].PortKey;
    event.State = "True";
    event.RevNum = 1;
    
    array_events.num = 1;
    array_events.elems = &event;
    
    return portevents(&array_events);    
}

int button_event(int buttonId, bool pressed)
{
    printf("button %d: %s\n", buttonId, (pressed) ? "pressed" : "released");
    
    Yodiwo_Plegma_PortEvent_t event;
    Array_Yodiwo_Plegma_PortEvent_t array_events;
    
    event.PortKey = button->Ports.elems[0].PortKey;
    event.State = (char *)((pressed) ? "True" : "False");
    event.RevNum = 1;
    
    array_events.num = 1;
    array_events.elems = &event;
    
    return portevents(&array_events);
}

void led_event(DigitalOut &led, Yodiwo_Plegma_PortEvent_t *event)
{
    if (!strcmp(event->State, "on") || !strcmp(event->State, "1")  || !strcmp(event->State, "true")
    || !strcmp(event->State, "True")  || !strcmp(event->State, "On")) {
        printf("ON\n");
        led = 0;
    } else {
        printf("OFF\n");
        led = 1;
    }
}

int handle_red_led(Yodiwo_Plegma_PortEvent_t *event)
{
    printf("event for red led\n");
    led_event(redled, event);
    return 0;
}

int handle_green_led(Yodiwo_Plegma_PortEvent_t *event)
{
    printf("event for green led\n");
    led_event(greenled, event);
    return 0;
}

int handle_blue_led(Yodiwo_Plegma_PortEvent_t *event)
{
    printf("event for blue led\n");
    led_event(blueled, event);
    return 0;
}

void initialize_things(char *nodeKey)
{
    // init thing pointers
    button = &_things[0];
    axel   = &_things[1];
    led    = &_things[2];
    
    //BUTTON
    button_port.ConfFlags = Yodiwo_ePortConf_None; //why not
    button_port.Description = "the state of the freedom button";
    button_port.Name = "BTN State";
    button_port.Type = Yodiwo_ePortType_Boolean;
    button_port.State = "False";
    button_port.RevNum = 1;
    button_port.ioDirection = Yodiwo_ioPortDirection_Output;
    button_port.PortKey = "";

    button->ThingKey = "";
    button->Name = "FRDM Button";
    button->Config.num = 0;
    button->Config.elems = NULL;
    button->Ports.num = 1;
    button->Ports.elems = &button_port;
    button->Type = "";
    button->BlockType = "";
    button->UIHints.Description = "";
    button->UIHints.IconURI = "/Content/VirtualGateway/img/icon-thing-genericbutton.png";

    //AXEL
    axel_port.ConfFlags = Yodiwo_ePortConf_IsTrigger; //why not
    axel_port.Description = "triggered when the shaker is shaked";
    axel_port.Name = "SHAKER SHAKED";
    axel_port.Type = Yodiwo_ePortType_Boolean;
    axel_port.State = "";
    axel_port.RevNum = 1;
    axel_port.ioDirection = Yodiwo_ioPortDirection_Output;
    axel_port.PortKey = "";

    axel->ThingKey = "";
    axel->Name = "FRDM SHAKER";
    axel->Config.num = 0;
    axel->Config.elems = NULL;
    axel->Ports.num = 1;
    axel->Ports.elems = &axel_port;
    axel->Type = "";
    axel->BlockType = "";
    axel->UIHints.Description = "";
    axel->UIHints.IconURI = "/Content/VirtualGateway/img/accelerometer.jpg";
    
    //LED
    _led_ports[0].ConfFlags = Yodiwo_ePortConf_None; //why not
    _led_ports[0].Description = "RED LED";
    _led_ports[0].Name = "RED LED";
    _led_ports[0].Type = Yodiwo_ePortType_Boolean;    
    _led_ports[0].State = "False";
    _led_ports[0].RevNum = 1;
    _led_ports[0].ioDirection = Yodiwo_ioPortDirection_Input;
    _led_ports[0].PortKey = "";

    _led_ports[1].ConfFlags = Yodiwo_ePortConf_None; //why not
    _led_ports[1].Description = "GREEN LED";
    _led_ports[1].Name = "GREEN LED";
    _led_ports[0].Type = Yodiwo_ePortType_Boolean;    
    _led_ports[1].State = "off";
    _led_ports[1].RevNum = 1;
    _led_ports[1].ioDirection = Yodiwo_ioPortDirection_Input;
    _led_ports[1].PortKey = "";
    
    _led_ports[2].ConfFlags = Yodiwo_ePortConf_None; //why not
    _led_ports[2].Description = "BLUE LED";
    _led_ports[2].Name = "BLUE LED";
    _led_ports[0].Type = Yodiwo_ePortType_Boolean;    
    _led_ports[2].State = "off";
    _led_ports[2].RevNum = 1;
    _led_ports[2].ioDirection = Yodiwo_ioPortDirection_Input;
    _led_ports[2].PortKey = "";
    
    led->ThingKey = "";
    led->Name = "FRDM LED";
    led->Config.num = 0;
    led->Config.elems = NULL;
    led->Ports.num = 3;
    led->Ports.elems = _led_ports;
    led->Type = "";
    led->BlockType = "";
    led->UIHints.Description = "";
    led->UIHints.IconURI = "/Content/VirtualGateway/img/icon-thing-genericlight.png";    

    things.num = 3;
    things.elems = _things;
    
    if (nodeKey != NULL) {
        int r;
        r = fill_Thing_Keys(&things.elems[0], nodeKey, 1);
        r = fill_Thing_Keys(&things.elems[1], nodeKey, 2);
        r = fill_Thing_Keys(&things.elems[2], nodeKey, 3);
        
        printf("fill keys returned: %d\n", r);
    }
}

void register_led_handlers()
{
    redled = 1;
    greenled = 1;
    blueled = 1;
    register_portevent_handler(things.elems[2].Ports.elems[0].PortKey, handle_red_led);
    register_portevent_handler(things.elems[2].Ports.elems[1].PortKey, handle_green_led);
    register_portevent_handler(things.elems[2].Ports.elems[2].PortKey, handle_blue_led);
}


#include "FXOS8700Q.h"
//FXOS8700Q acc( A4, A5, FXOS8700CQ_SLAVE_ADDR0); // Proper Ports and I2C address for Freescale Multi Axis shield
//FXOS8700Q mag( A4, A5, FXOS8700CQ_SLAVE_ADDR0); // Proper Ports and I2C address for Freescale Multi Axis shield
FXOS8700Q_acc acc( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1); // Proper Ports and I2C Address for K64F Freedom board
FXOS8700Q_mag mag( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1); // Proper Ports and I2C Address for K64F Freedom board
 
//MotionSensorDataUnits mag_data;
MotionSensorDataUnits acc_data;
// 
//MotionSensorDataCounts mag_raw;
//MotionSensorDataCounts acc_raw;
 
#define DOWNSAMPLING 50

void axel_thread(const void *args)
{
//    float faX, faY, faZ;
//    float fmX, fmY, fmZ;
//    int16_t raX, raY, raZ;
//    int16_t rmX, rmY, rmZ;
    acc.enable();
    printf("\r\n\nFXOS8700Q Who Am I= %X\r\n", acc.whoAmI());
    int count = 0;
    int shaken_cd = 0;
    while (true) {
//        if (client->isConnected())
        {
            acc.getAxis(acc_data);
            ++count %= DOWNSAMPLING;
            if (shaken_cd) shaken_cd--;
            if ((acc_data.x > 1.5f || acc_data.y > 1.5f || acc_data.z > 1.5f) && !shaken_cd) {
                printf("shaken, not stirred\n");
                shaken_cd = DOWNSAMPLING;
                shaken_event();
            }
            if (!count) {
        //        mag.getAxis(mag_data);

        
//                printf("FXOS8700Q ACC: X=%1.4f Y=%1.4f Z=%1.4f  \n", acc_data.x, acc_data.y, acc_data.z);


        //        printf("    MAG: X=%4.1f Y=%4.1f Z=%4.1f\r\n", mag_data.x, mag_data.y, mag_data.z);
        //        acc.getX(&faX);
        //        acc.getY(&faY);
        //        acc.getZ(&faZ);
        //        mag.getX(&fmX);
        //        mag.getY(&fmY);
        //        mag.getZ(&fmZ);
        //        printf("FXOS8700Q ACC: X=%1.4f Y=%1.4f Z=%1.4f  ", faX, faY, faZ);
        //        printf("    MAG: X=%4.1f Y=%4.1f Z=%4.1f\r\n", fmX, fmY, fmZ);
            }
        }
        Thread::wait(20);
    }
}