/*
 * YoPlegma (codename Nodas)
 * Yodiwo Plegma API example node
 *
 * NOTES:
 * a configuration file, named config.json (sample exists in this project) needs to be placed in the root of the SD card
 */

#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "HTTPD.h"

#include "SDFileSystem.h"                  // SD File System functions

#include "pairing_backend.h"
#include "pairing_http_handler.h"
#include "config.h"
#include "yodiwo_functions.h"
#include "yoplegma_things.h"
#include "mqtt_helpers.h"
#include "yodiwo_helpers.h"

#define DAT0 PTE3                          // MOSI
#define CMD  PTE1                          // MISO
#define CLK  PTE2                          // SCLK
#define CD   PTE4                          // CS


EthernetInterface eth;

DigitalOut blinking(LED4);

extern DigitalOut redled;
extern DigitalOut greenled;
extern DigitalOut blueled;

InterruptIn sw2(SW2);
uint32_t button_pressed;
Thread *thread2;
extern HTTPD *httpd;

 
 
SDFileSystem sd(DAT0, CMD, CLK, CD, "sd"); // MOSI, MISO, SCLK, CS
//Serial pc(USBTX, USBRX);                   // Virtual COM Port

Yodiwo_Tools_APIGenerator_CNodeYConfig_t configuration;
Yodiwo_Tools_APIGenerator_CNodeConfig_t *activeConfig;

extern pairing_context pairing_state;

void pairing_done(char *nodeKey, char *secretKey);

void sw2_press(void)
{
    thread2->signal_set(0x1);
}

void sw2_release(void)
{
    thread2->signal_set(0x2);    
}

void led_thread(void const *argument)
{
    while (true) {
        blinking = !blinking;
        Thread::wait(1000);
    }
}

void button_thread(void const *argument)
{
    redled = 0;
    greenled = 0;
    blueled = 0;
    while (true) {
        osEvent evt = Thread::signal_wait(0x1 | 0x02);
        if (evt.value.signals & 0x01) {
            button_event(1, true);
        }
        if (evt.value.signals & 0x02) {
            button_event(1, false);
        }
        
        button_pressed++;
    }
}

int launch_mqtt();

int main()
{

    eth.init();
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    int r = read_config(&configuration, "/sd/config.json");
    printf("read config returned: %d\n", r);
    activeConfig = &configuration.Configs.elems[configuration.ActiveID];
    
    printf("p: %p %p\n", activeConfig->NodeKey, activeConfig->NodeSecret);
    printf("...: %d %d\n", activeConfig->NodeKey[0], activeConfig->NodeKey[1]);    
    if (!activeConfig->NodeKey) {
        printf("not paired, launching HTTP server for pairing\n");
        start_pairing_http_server(&eth, 80, pairing_done);        
    } else {
        printf("found NodeKey: %s, proceeding to connection\n", activeConfig->NodeKey);
        launch_mqtt();
    }

//    eth.disconnect();
  

    button_pressed = 0;
    sw2.fall(&sw2_press);
    sw2.rise(&sw2_release);
    while (true) {
        Thread::wait(5000);
        fflush(stdout);
        button_pressed = 0;
    }
}

int launch_mqtt()
{
    int r;
    initialize_things(activeConfig->NodeKey);
    init_yodiwo(activeConfig->Name, &things, publisher);
    register_led_handlers();
    r = mqtt_init(activeConfig->MqttBrokerHostname, 
                     activeConfig->MqttBrokerPort, 
                     activeConfig->MqttBrokerCertFile, 
                     activeConfig->NodeKey,
                     activeConfig->NodeSecret
                     );
    if (r >= 0) {
        redled = 1;
        greenled = 1;
        blueled = 1;

        Thread thread(led_thread);
        thread2 = new Thread(button_thread, NULL, osPriorityNormal, 4000);
        Thread *at = new Thread(axel_thread);
    }
    return r;

}


void pairing_done(char *nodeKey, char *secretKey)
{
    printf("pairing done!\n");
    printf("NokeKey: %s\n", nodeKey);
    printf("SecretKey: %s\n", secretKey);
    activeConfig->NodeKey = nodeKey;
    activeConfig->NodeSecret = secretKey;
    int r = write_config(&configuration, "/sd/config.json");
    if (r < 0) {
        printf("error writing config to file\n");
    } else {
        printf("successfully written new config to file\n");
        printf("launching mqtt now...\n");
        launch_mqtt();
    }
}
