#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <stdbool.h>
#include "jsmn.h"
#include "config.h"

int read_config(Yodiwo_Tools_APIGenerator_CNodeYConfig_t *config, char *filename)
{
    FILE *f;
    int size;
    char *buf;
    int r;
    f = fopen(filename, "r");
    if (f == NULL) {
        return -1;    
    }
    fseek(f, 0L, SEEK_END);
    size = ftell(f);
    fseek(f, 0L, SEEK_SET);
    
    buf = (char *)malloc(sizeof(char) * (size + 10));
    if (buf == NULL) {
        r = -ENOMEM;
        goto exit;
    }
    size = fread(buf, 1, size, f);
    buf[size] = '\0';
    fclose(f);
    f = NULL;
    r = Yodiwo_Tools_APIGenerator_CNodeYConfig_FromJson(buf, size, config);
exit:
    free(buf);
    if (f != NULL)
    	fclose(f);
    return (r < 0) ? r : 0;
}

int write_config(Yodiwo_Tools_APIGenerator_CNodeYConfig_t *config, char *filename)
{
    FILE *f;
    char *buf;
    int r;
    f = fopen(filename, "w");
    if (f == NULL) {
        return -1;    
    }
    buf = (char *)malloc(2048); //TODO: proper
    if (buf == NULL) {
        r = -ENOMEM;
        goto exit;
    }
    r = Yodiwo_Tools_APIGenerator_CNodeYConfig_ToJson(buf, 2048, config);
    if (r < 0) 
        goto exit;
    fwrite(buf, r - 1, 1, f);
exit:
    free(buf);
    fclose(f);
    return (r < 0) ? r : 0;
}

