#pragma once

/*
Waarom client per server
Ten eerste moeten van een repons dan niet bepalen voor welke request hij juist was.
Alles dat voor een bepaalde client / socket toekomt is voor die client.
Dat betekent ook dat we niet eeuwig moeten wachten op een respons maar dat we async
kunnen werken en werken met timeouts. We overlopen dan gewoon constant de clients die nog
geen respons hebben gekregen.
*/

#include <string>
#include <vector>
#include "cantcoap.h"
#include "coap.h"
#include "response.h"
#include "request.h"

enum Method;

class Client {
    
    private:
        // ResourceRequest holding info of previous request
        struct ResourceRequest{
            uint32_t token_id;
            char* uri;
            void (*response_handler)(Request*, Response*);       // Not sure if we need request and respons PDU's
            int method;
            CoapPDU * req_pdu;
        };
    
    private:
        UDPSocket udp_socket;
        Endpoint coap_server;       // One client per endpoint
        uint32_t new_token_id;      // Matches requests and responses
        uint16_t new_message_id;
        std::string identifier;     // Identifier is some trivial string used for console output
        
        // List of unhandled previous requests
        std::vector<ResourceRequest> requests;
    
    public:
        Client(const char * server, const int port, std::string identifier="Client");
        
    public:
        void sendRequest(char* uri, void (*response_handler)(Request*, Response*), CoapPDU::Code method);
        void checkForResponse(void);
    
};