#include "response.h"


Response::Response() : CoapPDU()
{
       
}

Response::Response(uint8_t *pdu, int pduLength) : CoapPDU(pdu, pduLength)
{
    
}

Response::Response(uint8_t *buffer, int bufferLength, int pduLength) : CoapPDU(buffer, bufferLength, pduLength)
{
    
}

void Response::setContent(char* content, int length)
{
    CoapPDU::setCode(Response::COAP_CONTENT);
    setPayload(reinterpret_cast<uint8_t*>(content), length);
}

void Response::setCode(int code)
{
    CoapPDU::setCode((CoapPDU::Code) code);   
}