#pragma once

#include "mbed.h"
#include "EthernetInterface.h"
#include "cantcoap.h"
#include "dbg.h"

#include "server.h"
#include "client.h"

/// CoapCode enum, alias for CoapPDU::Code enum
enum CoapCode {
    EMPTY = CoapPDU::COAP_EMPTY,
    GET = CoapPDU::COAP_GET,
    POST = CoapPDU::COAP_POST,
    PUT = CoapPDU::COAP_PUT,
    DELETE = CoapPDU::COAP_DELETE,
    CREATED = CoapPDU::COAP_CREATED,
    DELETED = CoapPDU::COAP_DELETED,
    VALID = CoapPDU::COAP_VALID,
    CHANGED = CoapPDU::COAP_CHANGED,
    CONTENT = CoapPDU::COAP_CONTENT,
    BAD_REQUEST = CoapPDU::COAP_BAD_REQUEST,
    UNAUTHORIZED = CoapPDU::COAP_UNAUTHORIZED,
    BAD_OPTION = CoapPDU::COAP_BAD_OPTION,
    FORBIDDEN = CoapPDU::COAP_FORBIDDEN,
    NOT_FOUND = CoapPDU::COAP_NOT_FOUND,
    METHOD_NOT_ALLOWED = CoapPDU::COAP_METHOD_NOT_ALLOWED,
    NOT_ACCEPTABLE = CoapPDU::COAP_NOT_ACCEPTABLE,
    PRECONDITION_FAILED = CoapPDU::COAP_PRECONDITION_FAILED,
    REQUEST_ENTITY_TOO_LARGE = CoapPDU::COAP_REQUEST_ENTITY_TOO_LARGE,
    UNSUPPORTED_CONTENT_FORMAT = CoapPDU::COAP_UNSUPPORTED_CONTENT_FORMAT,
    INTERNAL_SERVER_ERROR = CoapPDU::COAP_INTERNAL_SERVER_ERROR,
    NOT_IMPLEMENTED = CoapPDU::COAP_NOT_IMPLEMENTED,
    BAD_GATEWAY = CoapPDU::COAP_BAD_GATEWAY,
    SERVICE_UNAVAILABLE = CoapPDU::COAP_SERVICE_UNAVAILABLE,
    GATEWAY_TIMEOUT = CoapPDU::COAP_GATEWAY_TIMEOUT,
    PROXYING_NOT_SUPPORTED = CoapPDU::COAP_PROXYING_NOT_SUPPORTED,
    UNDEFINED_CODE = CoapPDU::COAP_UNDEFINED_CODE
};

/// CoapType enum, alias for CoapPDU::Type enum
enum CoapType {
    CONFIRMABLE = CoapPDU::COAP_CONFIRMABLE,
    NON_CONFIRMABLE = CoapPDU::COAP_NON_CONFIRMABLE,
    ACKNOWLEDGEMENT = CoapPDU::COAP_ACKNOWLEDGEMENT,
    RESET = CoapPDU::COAP_RESET
};

class Coap{
    public:
    Coap();  
    
    protected:

};