#include "server.h"


Server::Server()
{
    debug_init();
    debug_set_newline("\r\n");
    
    eth.init(); //Use DHCP
    eth.connect();
    printf("\r\nServer IP Address is %s\r\n", eth.getIPAddress());
    
    server.bind(5683);
    server.set_blocking(false, 100);
}

char* Server::getIpAddress(){
    return eth.getIPAddress();
}

void Server::enableBroadcast(int broadcast)
{
    server.set_broadcasting(broadcast);
}

void Server::add(char* uri, void (*fnc)(Request*, Response*), CoapCode method)
{
    Resource res = {uri, fnc, method};
    resources.push_back(res);
}

void Server::waitForRequest()
{

    char buffer[UDP_BUFFER_SIZE];
    //printf("\r\nWaiting for UDP packet...\r\n");
    int size = server.receiveFrom(client, buffer, sizeof(buffer));
    buffer[size] = '\0';

    CoapPDU *req = new CoapPDU((uint8_t*)buffer,256, size);
    if(req->validate()) {
        
        char uriBuffer[URI_BUFFER_SIZE];
        int uriLength;
        uint8_t token[TOKEN_BUFFER_SIZE];
        uint8_t tokenLength;
    
        //req->printHuman();

        req->getURI(uriBuffer,URI_BUFFER_SIZE,&uriLength); 
        tokenLength = req->getTokenLength();
        memcpy(token, req->getTokenPointer(), tokenLength);
    
        int resourceIndex = findResource(uriBuffer, req->getCode());
    
        
        CoapPDU *res = new CoapPDU();
        res->setMessageID(req->getMessageID());
        res->setToken(token,4);
        
        switch(req->getType()){
            case CoapPDU::COAP_NON_CONFIRMABLE: 
                res->setType(CoapPDU::COAP_NON_CONFIRMABLE);
                break;
            case CoapPDU::COAP_CONFIRMABLE:
                res->setType(CoapPDU::COAP_ACKNOWLEDGEMENT);
        }
        
        res->setCode(CoapPDU::COAP_NOT_FOUND);
        
        if(resourceIndex != -1){
            res->setCode(CoapPDU::COAP_NOT_IMPLEMENTED);
            resources[resourceIndex].function((Request*)req, (Response*)res);
        }
        
        server.sendTo(client, (char*) res->getPDUPointer(),res->getPDULength());
        
        delete res;
        delete req;
    }
}

int Server::findResource(char* uri, CoapPDU::Code method)
{
    for(int i = 0; i < resources.size(); i++){
        if(strcmp(uri, resources[i].uri) == 0 && method == resources[i].method) return i;
    }
    return -1;
}