/*
Sensor measurement header file. 
*/

#ifndef _SENSOR_MEASURE_H
#define _SENSOR_MEASURE_H

#define NUMBER_SAMPLES 20 // NUMBER OF SAMPLES FOR SENSOR TESTING
#define NUMBER_SENSORS_REGULAR 8 // number for the array of sensors
#define NUMBER_SENSORS_SQUARE 0
#define BLACK_THRESHOLD 2

//define pinout for all the sensors
DigitalIn pin_right_right_up(PTC2);
DigitalIn pin_right_left_up(PTE30);
DigitalIn pin_right_right_down(PTE29);
DigitalIn pin_right_left_down(PTC1);
DigitalIn pin_left_right_down(PTB3);
DigitalIn pin_left_left_down(PTE22); //pte22
DigitalIn pin_left_right_up(PTE23); //pte29
DigitalIn pin_left_left_up(PTB2);


//timer used by the sensor
Timer sensorTimer;
Serial pc(USBTX, USBRX); //used for connection to PC/debugging
int counter1 = 0;

//structure for sensors
typedef struct sensor_data {
    DigitalIn* pin; 
    int  blackValue;
    int  whiteValue;   
    int  grayValue; // if sensor is used for squares will have a gray value;
    int  state;   
}sensor_data;


sensor_data right_right_up;
sensor_data right_left_up;
sensor_data right_right_down;
sensor_data right_left_down;
sensor_data left_right_down;
sensor_data left_left_down;
sensor_data left_right_up;
sensor_data left_left_up;


sensor_data *sensorArray [NUMBER_SENSORS_REGULAR]; //array just used for getting value out of the sensors, helps for iteration(see main program)

//Initialise values of all sensors
void sensor_initialise ()
{
    int arrayBuilder = 0; //integer solely used for populating the array
    //right_right
    right_right_up.pin = &pin_right_right_up;
    right_right_up.blackValue = 13000*BLACK_THRESHOLD;
    right_right_up.whiteValue = 72000;
    right_right_up.grayValue = 0; // 0 for all the non-square sensors
    right_right_up.state = 0; //setting all sensors as black at begging
    sensorArray [arrayBuilder++] = &right_right_up; //Array goes from rightmost to left, then centre?
    right_left_up.pin = &pin_right_left_up;
    right_left_up.blackValue = 11500*BLACK_THRESHOLD;
    right_left_up.whiteValue = 70000;
    right_left_up.grayValue = 0;
    right_left_up.state = 1;
    sensorArray [arrayBuilder++] = &right_left_up;
    right_right_down.pin = &pin_right_right_down;
    right_right_down.blackValue = 2000*BLACK_THRESHOLD;
    right_right_down.whiteValue = 12000;
    right_right_down.grayValue = 0;
    right_right_down.state = 0;
    sensorArray [arrayBuilder++] = &right_right_down;
    right_left_down.pin = &pin_right_left_down;
    right_left_down.blackValue = 2500*BLACK_THRESHOLD;
    right_left_down.whiteValue = 17000;
    right_left_down.grayValue = 0;
    right_left_down.state = 1;
    sensorArray[arrayBuilder++] = &right_left_down;
    left_right_down.pin = &pin_left_right_down;
    left_right_down.blackValue = 1800*BLACK_THRESHOLD;
    left_right_down.whiteValue = 14000;
    left_right_down.grayValue = 0;
    left_right_down.state = 1;
    sensorArray [arrayBuilder++] = &left_right_down;
    left_left_down.pin = &pin_left_left_down;
    left_left_down.blackValue = 3000*BLACK_THRESHOLD;
    left_left_down.whiteValue = 10000;
    left_left_down.grayValue = 0;
    left_left_down.state = 0;
    sensorArray [arrayBuilder++] = &left_left_down;
    left_right_up.pin = &pin_left_right_up;
    left_right_up.blackValue = 9500*BLACK_THRESHOLD; //??? it's a trick ;)
    left_right_up.whiteValue =  35000;
    left_right_up.grayValue = 0;
    left_right_up.state = 1;
    sensorArray [arrayBuilder++] = &left_right_up;
    left_left_up.pin = &pin_left_left_up;
    left_left_up.blackValue = 12000*BLACK_THRESHOLD;
    left_left_up.whiteValue = 46000;
    left_left_up.grayValue = 0;
    left_left_up.state = 0;
    sensorArray [arrayBuilder++] = &left_left_up;
}


//measuring function - returning whether it is black or white line:  "0" - black, "1" - white
int measure (sensor_data *sensor)
{
    sensorTimer.reset();                        //reset the timer
    double freq, period = 0.0;
    int n = 0;                                  //number of samples
    int sensor_new, sensor_old = 0;             //variable to remember old and new sensor states
    //double time_1 = sensorTimer.read();  used for debugging
    while (n < NUMBER_SAMPLES) {
        sensor_new = sensor->pin->read();
        if ( sensor_new== 1 && sensor_old == 0) {   // detect on rising edge
            n++;
        }
        sensor_old = sensor_new;
    }
    double time_2 = sensorTimer.read();
    // pc.printf(" delta time is %f , time 2 is %f " , (time_2 - time_1), time_2);  //Used for debugging

    period = time_2/((double)NUMBER_SAMPLES);       // Get time
    freq = (1/period);                              // Convert period (in us) to frequency (Hz).
    //pc.printf(" period is  %f  and freq is  %f ", period,freq); // Used for debugging

    // sensor->state = freq;
//    return 0;

//    if (sensor->grayValue != 0 && freq < (sensor->grayValue +  1000) && freq > (sensor.grayValue - 1000)) { //definitely not sure about that!
//        //this is a gray value sensor in its gray region
//        sensor->state = 2;
//        return 2;
//    }
    if (freq < (sensor->blackValue)) {
        sensor->state = 0;    //if it's less than black value it is black
        return 0;
    } else {
        sensor->state = 1;
    }
    return 1;
    //(freq < sensor->black_value*2)? 1 : 0; //freq
}
#endif