  AREA asm_func, CODE, READONLY
; Export my asm function locaiton so that the C compiler can find it and link
    EXPORT start_systick
    EXPORT measure_clock_cycles
;   
    ALIGN
;   
start_systick   
;   
; Setup base address for SysTick
    LDR r2, =0xE000E010 
; Setup SysTick and start
    LDR r0, [r2, #0x00]     ; Grab current SysTick control state
    LDR r1, =0x05           ; Mask to set SysTick clock source as processor clock and start it running
    ORRS r0, r0, r1
    STR r0, [r2, #0x00]
; Return to previous code
    BX  LR
;
measure_clock_cycles
;
    PUSH {r4-r7}
; Configure pin to sample from
    LDR r3, =0xF80FF094         ; Port C data direction register
    LDR r4, =0x00000020         ; Pin 5
    LDR r5, [r3]                ; Current config
    BICS r5, r5, r4             ; Turn PinC5 to 0, General Purpose Input
    STR r5, [r3]                ; Save config 
; Setup base address for current SysTick value
    LDR r5, =0xE000E018
; Sample starting SysTick   
    LSLS r0, r0, #2             ; Multiply by 2 as both rising and failing edges detected
    LDR r0, =0x00               ; Clear counter
    LDR r2, =0x20               ; Pin mask
    LDR r6, =0xF80FF090         ; Input register
    LDR r7, =0x00               ; Current pin state
    LDR r4, [r5]                ; Read current SysTick
loop
    LDR r3, [r6]                ; Read Input register
    ANDS r3, r3, r2             ; Mask out pin
    SUBS r3, r3, r7             ; Sneaky method of detecting bit change, equals zero when no change has occurred
    BEQ loop                    ; Loop Until change
    MOV r7, r3                  ; Store new pin state  
    ADDS r0, #1                 ; Increment counter by one
    SUBS r3, r3, r0             ; Subtract SAMPLES from counter
    BNE loop                    ; Loop until counter = samples
    LDR r1, [r5]                ; Read ending SysTick
; Compute time difference
    MOV r0, r4
    SBCS r0, r0, r1             ; r0 = r4 - r1
    BPL finish                  ; If result of subtraction creates a positive number, return r0, otherwise recalculate
    LDR r3, =0x00FFFFFF
    SUBS r0, r3, r1             ; r0 = (2^24 - 1 - r1) + r4
    ADDS r0, r0, r4
finish
; Return to previous code
    POP {r4-r7}
    BX LR
    ALIGN
    END
           