#ifndef SENSORS_H
#define SENSORS_H
 
#define CHANNEL_1 0x01
#define CHANNEL_2 0x02
 
#define CPU_CLOCK 48000000
 
/**
*   Start SysTick
*/
extern "C" void start_systick();
 
/**
*   Measure the period observed on the sensor indicated by "sensor"
*   TODO: Pin Routing
*/
extern "C" int measure_clock_cycles(int sensor, int samples);
 
float measure_frequency(int sensor, int samples)
{
    // Divide the number of cpu clock cycles by the number of measured periods of the measured waveform to
    // get the number of clock cycles per period
    int clock_cycles = measure_clock_cycles(sensor, samples) / samples;
    
    // Divide CPU_CLOCK by the number of clock cycles to get the period
    return (CPU_CLOCK / (float)clock_cycles);  
}
 
#endif