#include "mbed.h"
#include "print.h"
#include "Serial.h"
#include <stdarg.h>

uint8_t st[100]={0};
int size=0;


Print::Print(PinName Tx, PinName Rx)
{
  print_f = new Serial(Tx,Rx);
  print_f -> baud(19200);
  
}


void Print::ISR_Serial_Tx()
{    
   static int position=0,TxPosition=0;
 
   switch(TxPosition){
    case 0:
  
    print_f->putc('T');
    TxPosition++;
    break;
    
    case 1:
    print_f->putc(st[position++]);
    if(position>size)
       TxPosition++;
    break;
    
    case 2:
   /* UART送信の割り込みイベント解除 */
       print_f -> attach(NULL,Serial::TxIrq);
       position=0;
       TxPosition=0;
       size=0;
     break;  
   }
}


void Print::printf(const char* Format, ...)
{
  static uint16_t string_size = 0;
  
  
  va_list ArgList;
  va_start(ArgList, Format);
  
   print_f -> attach(this,&Print::ISR_Serial_Tx,Serial::TxIrq);

  while (*Format != '\0')
  {
    if (*Format == '%')
    {
      /* 0表示のフラグ */
      uint8_t zero_flag = 0;
      /* 符号表示フラグ */
      uint8_t sign_flag = 0;
      /* 左詰め表示フラグ*/
      uint8_t left_flag = 0;

      /* 全体幅 */
      int16_t o_width = 0;
      /* 小数点以下の幅 */
      int16_t dp_width = -1;

      /* 引数のデータ幅 */
      int16_t arg_width = 1;

      Format++;

      /* 0埋め，+表示，左詰め処理 */
      while (1)
      {
        /* 半角スペースは例外処理 */
        if (*Format == ' ');
        else if (*Format == '0')
        {
          zero_flag = 1;
        }
        else if (*Format == '+')
        {
          sign_flag = 1;
        }
        else if (*Format == '-')
        {
          left_flag = 1;
        }
        /* 処理は存在しない */
        else
        {
          break;
        }

        /* 処理が存在した */
        /* 調査する文字を次へ */
        Format++;
      }

      /* 全体幅処理 */
      while (1)
      {
        /* 半角スペースは例外処理 */
        if (*Format == ' ');
        else if ((*Format >= '0' && *Format <= '9'))
        {
          /* 既に入っている数値の桁数を上げる */
          o_width *= 10;
          /* 文字を整数値に直して加算 */
          o_width += (*Format - '0');
        }
        /* 処理は存在しない */
        else
        {
          break;
        }

        /* 処理が存在した */
        /* 調査する文字を次へ */
        Format++;
      }

      /* ピリオドを打っていた場合 */
      if (*Format == '.')
      {
        /*調査する文字を次へ*/
        Format++;

        /* ピリオド打ちによる操作有効 */
        dp_width = 0;

        /* 最大幅または小数点以下幅処理 */
        while (1)
        {
          /* 半角スペースは例外処理 */
          if (*Format == ' ');
          else if ((*Format >= '0' && *Format <= '9'))
          {
            /* 既に入っている数値の桁数を上げる */
            dp_width *= 10;
            /* 文字を整数値に直して加算 */
            dp_width += (*Format - '0');
          }
          /* 処理は存在しない */
          else
          {
            break;
          }

          /* 処理が存在した */
          /* 調査する文字を次へ */
          Format++;
        }
      }

      /* 指定子による出力 */
      /* 整数型数値 */
      if (*Format == 'd')
      {
        /* 引数読み込み */
        int val = va_arg(ArgList, int);
        int work = val;
        /* 桁数を調べる */
        while (work <= -10 || work >= 10)
        {
          work /= 10;
          arg_width++;
        }

        /* 負の数なら符号表示フラグセット */
        if (val < 0)
        {
          sign_flag = 1;
        }
        /* 指定子にピリオド打ちがあった場合は0埋め有効 */
        if (dp_width != -1)
        {
          zero_flag = 1;
        }

        /* スペース入力処理 */
        /* 左詰め処理が無ければ数字入力の前に処理 */
        if (left_flag == 0)
        {
          /* スペース幅(全体幅-数値幅，符号も考慮)が存在 かつ */
          /* (0埋め処理なし または 0埋め制限がある場合に限り，0埋めしないスペース幅が存在したら ) */
          /* 以上の場合スペース入力処理ループ */
          while (o_width - arg_width - sign_flag > 0 &&
                 (zero_flag == 0 || (dp_width != -1 && o_width - dp_width - sign_flag > 0)))
          {
            /* スペース入力 */
            st[string_size++] = ' ';
            /* 全体幅を減らす */
            o_width--;
          }
        }
        /* 符号入力，処理 */
        if (sign_flag)
        {
          if (val < 0)
          {
            /* -入力 */
            st[string_size++] = '-';
            /* 数値を絶対値にする */
            val = -val;
          }
          else
          {
            /* +入力 */
            st[string_size++] = '+';
          }
        }

        /* 0入力処理 */
        /* 0入力幅(全体幅-数値幅，符号も考慮)が存在する場合0入力処理ループ */
        while (dp_width - arg_width > 0)
        {
          /* 0入力 */
          st[string_size++] = '0';

          /* 0入力制限値を減らす */
          dp_width--;
          /* 全体幅を減らす */
          o_width--;
        }

        /* 引数データ幅分文字列データ幅加算 */
        string_size += arg_width;

        /* 下位桁から順に文字列に代入 */
        for (int16_t width_cnt = 0; width_cnt < arg_width; width_cnt++)
        {
          st[string_size - width_cnt - 1] = '0' + (val % 10);
          val /= 10;
        }

        /* スペース処理 */
        /* 左詰め処理がある場合 */
        if (left_flag == 1)
        {
          /* スペース幅(全体幅-数値幅，符号も考慮)が存在すれば処理 */
          while (o_width - arg_width - sign_flag > 0)
          {
            /* スペース入力 */
            st[string_size++] = ' ';
            o_width--;
          }
        }
      }
      /* 実数型数値 */
      else if (*Format == 'f')
      {
        double val;

        /* 10の倍数 */
        int ten_multi = 1;

        /* 小数点以下の幅指定が無ければ6桁にする */
        if (dp_width == -1) {
          dp_width = 6;
        }
        /* 小数部分の表示する部分を整数にするために10の倍数を作る */
        for (int width_cnt = 0; width_cnt < dp_width; width_cnt++)
        {
          ten_multi *= 10;
        }

        /* 必要小数部分が整数部分に出るようにして引数読み込み*/
        val = va_arg(ArgList, double) * ten_multi;

        double work = val / ten_multi;
        /* 引数データの元々の整数部分のデータ幅を調べる */
        while (work <= -10 || work >= 10)
        {
          work /= 10;
          arg_width++;
        }

        /* 負の数なら符号表示フラグセット */
        if (val < 0)
        {
          sign_flag = 1;
        }

        /* スペース入力処理 */
        /* 左詰め処理が無ければ数字入力の前に処理 */
        if (left_flag == 0)
        {
          /* スペース入力幅(全体幅-ピリオド-小数部分幅-整数部分幅，符号も考慮)が存在 かつ */
          /* 0埋め処理なし */
          /* 以上の場合スペース入力処理ループ */
          while (o_width - 1 - dp_width - arg_width - sign_flag > 0 && zero_flag == 0 )
          {
            /* スペース入力 */
            st[string_size++] = ' ';
            /* 全体幅を減らす */
            o_width--;
          }
        }
        /* 符号入力，処理 */
        if (sign_flag)
        {
          if (val < 0)
          {
            /* -入力 */
            st[string_size++] = '-';
            /* 数値を絶対値にする */
            val = -val;
          }
          else
          {
            /* +入力 */
            st[string_size++] = '+';
          }
        }

        /* 0入力処理 */
        /* 左詰め処理が無ければ処理 */
        if (left_flag == 0)
        {
          /* 0入力幅(全体幅-ピリオド-小数部分幅-整数部分幅，符号も考慮)が存在する場合0入力処理ループ */
          while (o_width - 1 - dp_width - arg_width - sign_flag > 0)
          {
            /* 0入力 */
            st[string_size++] = '0';

            /* 全体幅を減らす */
            o_width--;
          }
        }

        /* (引数データ整数部分幅 + ピリオド + 小数部分幅)分文字列データ幅加算 */
        string_size += (arg_width + 1 + dp_width);

        /* 下位桁から順に文字列に代入 */
        /* 小数部分 */
        for (int width_cnt = 0; width_cnt < dp_width; width_cnt++)
        {
          st[string_size - width_cnt - 1] = '0' + ((int)val % 10);
          val /= 10;
        }
        /* ピリオド */
        st[string_size - dp_width - 1] = '.';
        /* 整数部分 */
        for (int16_t width_cnt = 0; width_cnt < arg_width; width_cnt++)
        {
          st[string_size - dp_width - 1 - width_cnt - 1] = '0' + ((int)val % 10);
          val /= 10;
        }

        /* スペース処理 */
        /* 左詰め処理がある場合 */
        if (left_flag == 1)
        {
          /* スペース入力幅(全体幅-ピリオド-小数部分幅-整数部分幅，符号も考慮)が存在処理 */
          while (o_width - 1 - dp_width - arg_width - sign_flag > 0)
          {
            /* スペース入力 */
            st[string_size++] = ' ';
            o_width--;
          }
        }
      }
      /* 文字 */
      else if (*Format == 'c')
      {
        char chara = (char)va_arg(ArgList, int);

        /* 左詰め処理が無ければ数字入力の前に処理 */
        if (left_flag == 0)
        {
          /* スペース入力処理 */
          /* スペース入力幅(全体幅-1文字)が存在 かつ */
          /* 0埋め処理なし */
          /* 以上の場合スペース入力処理ループ */
          while (o_width - 1 > 0 && zero_flag == 0)
          {
            /* スペース入力 */
            st[string_size++] = ' ';
            /* 全体幅を減らす */
            o_width--;
          }
          /* 0入力処理 */
          /* 0入力幅(全体幅-1文字)が存在 する場合0入力処理ループ */
          while (o_width - 1 > 0)
          {
            /* 0入力 */
            st[string_size++] = '0';

            /* 全体幅を減らす */
            o_width--;
          }
        }

        st[string_size++] = chara;

        /* スペース処理 */
        /* 左詰め処理がある場合 */
        if (left_flag == 1)
        {
          /* スペース幅(全体幅-1文字)が存在すれば処理 */
          while (o_width - 1 > 0)
          {
            /* スペース入力 */
            st[string_size++] = ' ';
            o_width--;
          }
        }
      }
      /* 文字列 */
      else if (*Format == 's')
      {
        char *chara = va_arg(ArgList, char *);
        char *work = chara;

        arg_width = 0;
        while (*work != '\0')
        {
          work++;
          arg_width++;
        }

        /* 左詰め処理が無ければ数字入力の前に処理 */
        if (left_flag == 0)
        {
          /* スペース入力処理 */
          /* スペース入力幅(全体幅-文字幅)が存在 かつ */
          /* 0埋め処理なし */
          /* 以上の場合スペース入力処理ループ */
          while (o_width - arg_width > 0 && zero_flag == 0)
          {
            /* スペース入力 */
            st[string_size++] = ' ';
            /* 全体幅を減らす */
            o_width--;
          }
          /* 0入力処理 */
          /* 0入力幅(全体幅-文字幅)が存在 する場合0入力処理ループ */
          while (o_width - arg_width > 0)
          {
            /* 0入力 */
            st[string_size++] = '0';

            /* 全体幅を減らす */
            o_width--;
          }
        }

        for (int16_t width_cnt = 0; width_cnt < arg_width; width_cnt++)
        {
          st[string_size++] = chara[width_cnt];
        }

        /* スペース処理 */
        /* 左詰め処理がある場合 */
        if (left_flag == 1)
        {
          /* スペース幅(全体幅-文字幅)が存在すれば処理 */
          while (o_width - arg_width > 0)
          {
            /* スペース入力 */
            st[string_size++] = ' ';
            o_width--;
          }
        }
      }
      else {
        st[string_size++] = *Format;
      }
      Format++;
    }
    else {
      st[string_size++] = *Format;
      Format++;
    }
  }
  va_end(ArgList);
  st[string_size]='q';
  size=string_size;
  string_size = 0;
}


