#include "mbed.h"
#include "conste.h"

CONSTE conste(PA_0,PA_1, 9600);

DigitalOut led(LED2);
Serial telemetry(USBTX, USBRX, 9600);

/* 操縦権 0…停止 1…手動 1…自動 */
int operate = 0;
/* 座標移動追従出来ているか(現在座標と目標座標の大きさは小さいか) */
int isFollow = 0;

int main()
{
    // 識別番号 0…のあ 1…ねぷちゅーん 2…とりとん 4…リモコン1 6…リモコン2
    conste.identificationNum = 0;

    while(1) {
        // ロボットの状態 1…モード異常 2…座標追従異常 3…正常
        conste.status = (operate == 1) << 1 | (isFollow == 1);
        
        /* 非常停止の時，モーターを止める */
        if(conste.isEMO) /*MovMotor[i] = 0*/;

        telemetry.printf("%d\n\r",conste.timeMs);
    }
}
