/*!
 * \file
 * \copyright
 * Copyright (C) Xsens Technologies B.V., 2015.  All rights reserved.
 *
 * This source code is intended for use only by Xsens Technologies BV and
 * those that have explicit written permission to use it from
 * Xsens Technologies BV.
 *
 * THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 * PARTICULAR PURPOSE.
 */

#include "xsdeviceid.h"

/*!
 * \brief Return true if device ID corresponds to a MTi-1 series device.
 */
bool XsDeviceId_isMtMk4_X(uint32_t deviceId)
{
	uint8_t deviceSeries = (deviceId >> 20) & 0xF;
	return ((deviceSeries == 0x8) || (deviceSeries == 0xC));
}

/*!
 * \brief Get a string describing the function of the MTi device.
 */
char const* XsDeviceId_functionDescription(enum DeviceFunction function)
{
	switch (function)
	{
		case DF_IMU:
			return "Inertial Measurement Unit";

		case DF_VRU:
			return "Vertical Reference Unit";

		case DF_AHRS:
			return "Attitude Heading Reference System";
	}

	return "Unknown device function";
}

