/*!
 * \file
 * \copyright
 * Copyright (C) Xsens Technologies B.V., 2015.  All rights reserved.
 *
 * This source code is intended for use only by Xsens Technologies BV and
 * those that have explicit written permission to use it from
 * Xsens Technologies BV.
 *
 * THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 * PARTICULAR PURPOSE.
 */

#ifndef __XBUSUTILITY_H
#define __XBUSUTILITY_H

#include <stdint.h>

uint8_t const* XbusUtility_readU8(uint8_t* out, uint8_t const* in);
uint8_t const* XbusUtility_readU16(uint16_t* out, uint8_t const* in);
uint8_t const* XbusUtility_readU32(uint32_t* out, uint8_t const* in);

uint8_t* XbusUtility_writeU8(uint8_t* out, uint8_t in);
uint8_t* XbusUtility_writeU16(uint8_t* out, uint16_t in);
uint8_t* XbusUtility_writeU32(uint8_t* out, uint32_t in);

#endif // __XBUSUTILITY_H
