/*!
 * \file
 * \copyright
 * Copyright (C) Xsens Technologies B.V., 2015.  All rights reserved.
 *
 * This source code is intended for use only by Xsens Technologies BV and
 * those that have explicit written permission to use it from
 * Xsens Technologies BV.
 *
 * THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 * PARTICULAR PURPOSE.
 */

#ifndef __MTDATA2_H
#define __MTDATA2_H

#include <stdint.h>
#include <stdbool.h>

/*! \brief Xbus message ID for MTData2 packets. */
#define MTDATA2_MESSAGE_ID (0x36)

#ifdef __cplusplus
extern "C" {
#endif

enum XsDataIdentifier
{
	XDI_PacketCounter  = 0x1020,
	XDI_SampleTimeFine = 0x1060,
	XDI_Quaternion     = 0x2010,
	XDI_DeltaV         = 0x4010,
	XDI_Acceleration   = 0x4020,
	XDI_RateOfTurn     = 0x8020,
	XDI_DeltaQ         = 0x8030,
	XDI_MagneticField  = 0xC020,
	XDI_StatusWord     = 0xE020,
};

bool MtData2_getItem(void* item, enum XsDataIdentifier id, uint8_t const* data, uint16_t dataLength);

#ifdef __cplusplus
}
#endif // extern "C"

#endif // __MTDATA2_H
