/*!
 * \file
 * \copyright
 * Copyright (C) Xsens Technologies B.V., 2015.  All rights reserved.
 *
 * This source code is intended for use only by Xsens Technologies BV and
 * those that have explicit written permission to use it from
 * Xsens Technologies BV.
 *
 * THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 * PARTICULAR PURPOSE.
 */

#ifndef __XSDEVICEID_H
#define __XSDEVICEID_H

#include <stdint.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C" {
#endif

bool XsDeviceId_isMtMk4_X(uint32_t deviceId);

enum DeviceFunction
{
	/*! \brief Inertial Measurement Unit. */
	DF_IMU  = 1,
	/*! \brief Vertical Reference Unit. */
	DF_VRU  = 2,
	/*! \brief Attitude Heading Reference System. */
	DF_AHRS = 3
};

/*!
 * \brief Get the function of the MTi device.
 */
static inline enum DeviceFunction XsDeviceId_getFunction(uint32_t deviceId)
{
	return (enum DeviceFunction)((deviceId >> 24) & 0xF);
}

char const* XsDeviceId_functionDescription(enum DeviceFunction function);

#ifdef __cplusplus
}
#endif // extern "C"

#endif // __XSDEVICEID_H
