/*!
 * \file
 * \copyright
 * Copyright (C) Xsens Technologies B.V., 2015.  All rights reserved.
 *
 * This source code is intended for use only by Xsens Technologies BV and
 * those that have explicit written permission to use it from
 * Xsens Technologies BV.
 *
 * THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 * PARTICULAR PURPOSE.
 */

#include "xbusutility.h"

uint8_t const* XbusUtility_readU8(uint8_t* out, uint8_t const* in)
{
	*out = *in;
	return ++in;
}

uint8_t const* XbusUtility_readU16(uint16_t* out, uint8_t const* in)
{
	*out = (in[0] << 8) | in[1];
	return in + sizeof(uint16_t);
}

uint8_t const* XbusUtility_readU32(uint32_t* out, uint8_t const* in)
{
	*out = (in[0] << 24) | (in[1] << 16) | (in[2] << 8) | in[3];
	return in + sizeof(uint32_t);
}
