
#ifndef ROONEYENGINE_H
#define ROONEYENGIN_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Rooney.h"
#include "Ball.h"
/** control struct */
struct control {
  Vector2D c; /**< Vector 2D for joystick x */ 
  };
  /** RooneyEngine class
  * @1 make the whole game run and set the score the reset process
  * @2 cheak the collision and the reset or fall flag
  * @3 draw on the lcd screen and load the gamepad controll
  * @date May 14th 2020
  * @author Yang Zhenye

@ code

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "RooneyEngine.h"
@endcode
*/




class RooneyEngine{
    public:
    // Constructor and destructor.
    /**
    * @brief Constructor @details Non user specified.
    */
    RooneyEngine();
    /**
    * @brief Destructor @details Non user specified.
    */
    ~RooneyEngine();
 // Mutators.
      /**
  * @brief Initalises the RooneyEngine
  */
    void init();
  /**
  * @brief reset the RooneyEngine.
  */ 
    void reset();
  /**
  * @brief get the coordinate and the button_flag.
  * @param &gamepad @details The gamepad object from Gamepad class.
  */ 
    void read_input(Gamepad &pad);
  /**
  * @brief check and flesh the reset flag.
  * @param &gamepad @details The gamepad object from Gamepad class.
  * @param &lcd @details The lcd object from the N5110 class
  */ 
    void check_reset(N5110 &lcd, Gamepad &gamepad);
  /**
  * @brief check and flesh the start flag.
  * @param &gamepad @details The gamepad object from Gamepad class.
  * @param &lcd @details The lcd object from the N5110 class
  */ 
    void check_start(N5110 &lcd, Gamepad &gamepad);
  /**
  * @brief check and flesh the collision flag.
  * @param &gamepad @details The gamepad object from Gamepad class.
  */
    void check_collision(Gamepad &gamepad);
  /**
  * @brief get the player score.
  */
    int get_score();
  /**
  * @brief get the player speed.
  */
    int get_speed();
  /**
  * @brief get the sprite.
  */ 
    void get_sprite(N5110 &lcd);
  /**
  * @brief Updates the LCD display.
  * @param &lcd @details The lcd object from the N5110 class.
  */
    void update_lcd(N5110 &lcd);
  /**
  * @brief run the game.
  */
    void run_engine(N5110 &lcd, Gamepad &gamepad);
  /**
  * @brief get the reset flag.
  */ 
    bool get_reset_flag();
  /**
  * @brief get the start flag.
  */ 
    bool get_start_flag();
  /**
  * @brief get player's x
  */
    void get_rooney_x(Gamepad &gamepad,int speed,float joy_x);
    private:
    control _control;
    player _player;
    rooneybody body;
    int _player_x;
    int _player_y;
    int _x;
    int _y;
    bool _collision_flag;
    bool _start_flag;
    bool _reset_flag;
    int _speed;
    int _player_score;
};
#endif
    