#include <stdio.h>
#include <time.h>
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#define length 80
/** main Class
@author Zou yunting, University of Leeds
@brief used to set the lparameters of the snake and the food
@15th May 2020
**/

/** objects **/ 
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
 
/**structure**/
struct vip {      //@set the location of the snake
    int x;
    int y;    
}COOR;
 
struct Serpent {
    vip head[length]; //@set the length of the viper
    int n;   //@number of snake's section  
}SER;
struct target{
   vip var;//@set the variable of target
}target;
 


void viper();
void Movement();     //set the direction control of the snake
void goal();         //set the target food
void gameover();     //set the failure screen
float wtime;         //related to the speed of the snake
int score ;
int HP;              // Snake's health point(HP), if HP=0, game over.
int D;               //set the variable of direction
int d;               //set the variable for the control of joystick
 
 // define the location of the snake       1
 void defineSnake(){
     for(int i = 1; i < SER.n; i++){
         SER.head[i].x = SER.head[i-1].x;
         SER.head[i].y = SER.head[i-1].y-1;//draw snake from top to bottom
         }
     }

 
//show a snake by creating array          2
void viper()
{
        for(int i = 0; i < SER.n; i++){
        lcd.drawRect(SER.head[i].x,SER.head[i].y,1,1,FILL_TRANSPARENT);
        }
           
}
 
 
//implement the movement function              3
void Movement()
{
    d = pad.get_direction();//use joystick to control the direction of snake
    if (d == N ){
        D = 1;//up
        }
    else if ( d == S ){
        D = 2;//down
        }
    else if (d == W ){
        D = 3;//left
        }
    else if ( d == E ){
        D = 4;//right
        }
//@add or substract the array to move the snake in x,y axis
    for(int i = SER.n; i >0; i--){
        SER.head[i].x = SER.head[i-1].x;
        SER.head[i].y = SER.head[i-1].y;
        }
    //@let snake move for different direction
    if (D == 1 ){
        SER.head[0].x = SER.head[0].x;
        SER.head[0].y -= 1;
        }//turn upwards
    else if (D == 2 ){
        SER.head[0].x = SER.head[0].x;
        SER.head[0].y += 1;
        }//turn downwards
    else if (D == 3 ){
        SER.head[0].x -= 1;
        SER.head[0].y = SER.head[0].y;
        }//turn left
    else if (D == 4 ){
        SER.head[0].x += 1;
        SER.head[0].y = SER.head[0].y;
        }//turn right
    
 }


//generate a random target                   4           
void goal(){
    srand(unsigned (time(NULL)));
    target.var.x = rand() % 80; // The target appears at random location
    target.var.y = rand() % 40;
    
    }
    
    
// if snake get the target, change the length and the score                6
void gettarget(){
//juge if snake eat food
    if(SER.head[0].x == target.var.x && SER.head[0].y == target.var.y ){
        SER.n += 7;
       goal();//generate a new target when the previous target has been eaten
       pad.tone(650,1);// @sounds
       score += 1;// when the snake get its target, the score plus one
        }
    }



