#include"Snake.h"
 
Snake::Snake()
{
    curr=head=new Body(24,17);
    curr->next=new Body(24,13);
    curr->next->next=new Body(24,9);
    tail=curr->next->next;
    tail->next=NULL;
    length=3;
    direction=4;
    _height=4;
    _width=4;
}
 
Snake::~Snake()
{
    curr=head;
    while(curr!=NULL)
    {
        head=head->next;
        delete curr;
        curr=head;
    }
}
 
void Snake::grow()
{
    curr=head;
    Body* temp=new Body;
    
    while(curr->next!=tail)
    {
        curr=curr->next;
    }
    
    if(curr->x==tail->x)
    {
        if(curr->y>tail->y)
        {
            temp->x=tail->x;
            temp->y=tail->y+_height;
        }
        else
        {
            temp->x=tail->x;
            temp->y=tail->y-_height;
        }
    }
    else if(curr->y==tail->y)
    {
        if(curr->x>tail->x)
        {
            temp->x=tail->x-_width;
            temp->y=tail->y;
        }
        else
        {
            temp->x=tail->x+_width;
            temp->y=tail->y;
        }
    }
    tail=temp;
    tail->next=NULL;
    curr->next->next=tail;
    curr=head;
    length++;
}

const int& Snake::getdir()
{
        return direction;
}

void Snake::move(N5110 &lcd)
{
    curr=head;
    Body* temp=new Body;
    switch (direction){
    case 1:
        temp->x=head->x-_width;
        temp->y=head->y;
        head=temp;
        head->next=curr;
        break;
    case 2:
        temp->x=head->x+_width;
        temp->y=head->y;
        head=temp;
        head->next=curr;
        break;
    case 3:
        temp->x=head->x;
        temp->y=head->y-_height;
        head=temp;
        head->next=curr;
        break;
    case 4:
        temp->x=head->x;
        temp->y=head->y+_height;
        head=temp;
        head->next=curr;
        break;
       }
    while(curr->next!=tail)
        {
        curr=curr->next;
        }
        
    while(lcd.getPixel(head->x,head->y)==true)
         {
            lcd.clear();
            lcd.printString("  GAME  OVER   ",0,3);
            lcd.refresh();
            lcd.inverseMode();
            wait(0.5);
            lcd.normalMode();
            wait(0.5);
        }
            delete tail;
            tail=curr;
            tail->next=NULL;
            curr=head;  
            draw(lcd);
        }//把尾巴接到头前面的一个,实现移动控制
    
void Snake::update(Gamepad &pad)
{
        if (pad.check_event(Gamepad::X_PRESSED) == true)
        {
            if (direction != 2)//不能控制蛇走相反的反向
            direction = 1;
            }
        else if (pad.check_event(Gamepad::B_PRESSED) == true)
        {
            if (direction != 1)
            direction = 2;
            }
        else if (pad.check_event(Gamepad::Y_PRESSED) == true)
         {
            if (direction != 4)
            direction = 3;
            }
        else if (pad.check_event(Gamepad::A_PRESSED) == true)
        {
            if (direction != 3)
            direction = 4;
            }
}

const Body* Snake::gethead()
{
    return head;
}
 
const Body* Snake::gettail()
{
    return tail;
}

const Body* Snake::getcurr()
{
    return curr;
}

 const int &Snake::getlength()
 {
     return length;
     }

void Snake::backcurr()
{
    curr=head;
}

void Snake::draw(N5110 &lcd)
{
    lcd.drawRect(gethead()->x, gethead()->y,_height,_width,FILL_TRANSPARENT);
    lcd.setPixel(gettail()->x,gettail()->y,false);
    lcd.setPixel(gettail()->x+1,gettail()->y,false);
    lcd.setPixel(gettail()->x+2,gettail()->y,false);
    lcd.setPixel(gettail()->x+3,gettail()->y,false);
    lcd.setPixel(gettail()->x,gettail()->y+1,false);
    lcd.setPixel(gettail()->x,gettail()->y+2,false);
    lcd.setPixel(gettail()->x,gettail()->y+3,false);
    lcd.setPixel(gettail()->x+1,gettail()->y+3,false);
    lcd.setPixel(gettail()->x+2,gettail()->y+3,false);
    lcd.setPixel(gettail()->x+3,gettail()->y+3,false);
    lcd.setPixel(gettail()->x+3,gettail()->y+1,false);
    lcd.setPixel(gettail()->x+3,gettail()->y+2,false);
    }
/*
void Snake::add_score()
{
    score_v = _menu.get_score_v();
    _score += score_v;
    }
    
int Snake::get_score()
{
    return _score;
    }
    */