#include "Menu.h"

Menu::Menu()
{
}

Menu::~Menu()
{
}

void Menu::init(Gamepad &pad,N5110 &lcd)
{
    lcd.clear();
    lcd.printString("     SNAKE    ",0,1);
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
    // wait flashing LEDs until start button is pressed
    //start 键不等于false 的时候跳出去  也就是按下就跳出循环
    while (1) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
        if(pad.check_event(Gamepad::START_PRESSED) == true)
         break;
    }
    pad.tone(1000.0,0.1);
    changespeed1(pad,lcd);
    wait(0.5);
}

void Menu::changemap(Gamepad &apd,N5110 &lcd)
{
    lcd.clear();
    lcd.printString("   Rookie   ",0,1);
    lcd.printString("   

void Menu::changespeed1(Gamepad &pad,N5110 &lcd)
{
    lcd.clear();
    lcd.printString(" Change Speed ",0,1);
    lcd.printString("  < Normal >  ",0,3);
    lcd.refresh();
    while (1) {
         wait(0.2);
         if(pad.check_event(Gamepad::START_PRESSED) == true)
         break;
         if(pad.check_event(Gamepad::BACK_PRESSED) == true){
             pad.tone(1500.0,0.1);
             init(pad,lcd);
             break;
             }
         d = pad.get_direction();
         wait(0.1);
         if (d == W) {
         changespeed2(pad,lcd);
             }
         else if (d == E) {
             changespeed3(pad,lcd);
             }
             }
    pad.tone(1000.0,0.1);
    speed = 3;
    sv = 15;
    game(pad,lcd);
}

void Menu::changespeed2(Gamepad &pad,N5110 &lcd)
{
    lcd.clear();
    lcd.printString(" Change Speed ",0,1);
    lcd.printString("  <  Easy  >  ",0,3);
    lcd.refresh();
    while (1) {
         wait(0.2);
         if(pad.check_event(Gamepad::START_PRESSED) == true)
         break;
         if(pad.check_event(Gamepad::BACK_PRESSED) == true){
             pad.tone(1500.0,0.1);
             init(pad,lcd);
             break;
             }
         d = pad.get_direction();
         wait(0.1);
         if(d == E) {
             changespeed1(pad,lcd);
           }
           }
    pad.tone(1000.0,0.1);
    speed = 2;
    sv = 10;
    game(pad,lcd);
}

void Menu::changespeed3(Gamepad &pad,N5110 &lcd)
{
    lcd.clear();
    lcd.printString(" Change Speed ",0,1);
    lcd.printString("  <  Hard  >  ",0,3);
    lcd.refresh();
    while (1) {
         wait(0.2);
         if(pad.check_event(Gamepad::START_PRESSED) == true)
         break;
         if(pad.check_event(Gamepad::BACK_PRESSED) == true){
             pad.tone(1500.0,0.1);
             init(pad,lcd);
             break;
             }
         d = pad.get_direction();
         wait(0.1);
         if(d == W) {
         changespeed1(pad,lcd);
         }
    }
    pad.tone(1000.0,0.1);
    speed = 5;
    sv = 20;
    game(pad,lcd);
}

// this function draws each frame on the LCD
void Menu::render(Gamepad &pad,N5110 &lcd)
{
    // clear screen, re-draw and refresh
    eatfood(pad,lcd);
    printscore(lcd);
    lcd.refresh();
}

void Menu::eatfood(Gamepad &pad,N5110 &lcd)
{
    Vector2D food_pos = _food.get_pos();
    _snake.backcurr();
    _snake.update(pad);
    lcd.drawRect(3,8,78,38,FILL_TRANSPARENT);
    _snake.move(lcd);
    //int i=0;
    //while (1){
    //if (i==3)
    //break;
    if ((_snake.gethead()->x == food_pos.x-1) && (_snake.gethead()->y == food_pos.y-1)){
        pad.tone(750.0,0.1);
        lcd.setPixel(food_pos.x,food_pos.y,false);
        lcd.setPixel(food_pos.x+1,food_pos.y,false);
        lcd.setPixel(food_pos.x,food_pos.y+1,false);
        lcd.setPixel(food_pos.x+1,food_pos.y+1,false);
        _snake.grow();
        _food.creat(lcd);
        _snake.backcurr();
        add_score();  
       // i++;
        }
    }
    /*
    lcd.setPixel(food_pos.x,food_pos.y-1,true);
    lcd.setPixel(food_pos.x-1,food_pos.y,true);
    lcd.setPixel(food_pos.x+1,food_pos.y-1,true);
    lcd.setPixel(food_pos.x-2,food_pos.y,true);
    if ((_snake.gethead()->x == food_pos.x-1) && (_snake.gethead()->y == food_pos.y-1)){
        pad.tone(750.0,0.1);
        lcd.setPixel(food_pos.x,food_pos.y,false);
        lcd.setPixel(food_pos.x+1,food_pos.y,false);
        lcd.setPixel(food_pos.x,food_pos.y+1,false);
        lcd.setPixel(food_pos.x+1,food_pos.y+1,false);
        lcd.setPixel(food_pos.x,food_pos.y-1,false);
        lcd.setPixel(food_pos.x-1,food_pos.y,false);
        lcd.setPixel(food_pos.x+1,food_pos.y-1,false);
        lcd.setPixel(food_pos.x-2,food_pos.y,false);
        _food.creat(lcd);
        _snake.backcurr();
        add_score();  
        i=0;
        }
}
*/
    
void Menu::printscore(N5110 &lcd)
{
    int score = get_score();
    
    char buffer[14];
    sprintf(buffer,"Score :  %2d  ",score);
    lcd.printString(buffer,4,0);   
    }

void Menu::game(Gamepad &pad,N5110 &lcd)
{
    int fps = speed;
    wait(0.1);
    lcd.clear();
    wait(0.1);
    _food.creat(lcd);
   while (1) {
        gameover(lcd);
        render(pad,lcd);
        wait(1.0f/fps);
        if (pad.check_event(Gamepad::START_PRESSED) == true)
        break;
        }
    pad.tone(1000.0,0.1);
    pause(pad,lcd);
}

void Menu::pause(Gamepad &pad,N5110 &lcd)
{
    while (1) {
        lcd.clear();
        printscore(lcd);
        lcd.printString("     Pause   ",0,3);
        lcd.drawRect(3,8,78,38,FILL_TRANSPARENT);
        lcd.refresh();
        if (pad.check_event(Gamepad::BACK_PRESSED) == true)
        break;
        }
    pad.tone(1500.0,0.1);
    game(pad,lcd);
}
  
void Menu::gameover(N5110 &lcd)
{
     while(
        (_snake.gethead()->x < 4)|| 
        (_snake.gethead()->x > 77)||//78+3-4
        (_snake.gethead()->y < 9)||
        (_snake.gethead()->y > 41)//38+7-4
        ){
            lcd.clear();
            lcd.printString("  GAME  OVER   ",0,3);
            lcd.refresh();
            lcd.inverseMode();
            wait(0.5);
            lcd.normalMode();
            wait(0.5);
         }         
}

void Menu::add_score()
{
    _score += sv;
    }
    
int Menu::get_score()
{
    return _score;
    }