#include "Snake.h"

Snake::Snake(){}
Snake::~Snake(){}

pos apple;
Body greedy;

void Snake::drawApple(N5110 &lcd){
    
        lcd.setPixel(apple.x,apple.y);
            
}//end drawing
void Snake::initApple(){
        srand(time(NULL));   
        apple.x = (rand()%49)+6 ;           
        apple.y = (rand()%25)+9; 
}// end initializing
    
void Snake::produceApple(){
        
        srand(time(NULL));
        apple.x=(rand()%49)+6;
        apple.y=(rand()%25)+9; //set apple's position
    
}

pos Snake::getPos(){
        return apple;
} //end producing

void Snake::gameover(N5110 &lcd){
        
        Life--;
        for (;Life==0;){ 
        
            lcd.clear();
            lcd.printString("  You dead  ",0,1);
            lcd.printString("   Score:  ",0,3);  
            
            char buffer[2];
            sprintf(buffer,"%2d",L-6);
            lcd.printString(buffer,60,3);
            
            lcd.printString(" Reset the pad",0,4);
            lcd.printString("  to restart  ",0,5);
            lcd.refresh(); 
        }
            init(beginX,beginY,beginL,Life);
            
    }  //Reset the pad to restart the game.

 
void Snake::WallMeet(N5110 &lcd){
    
    if (greedy.bodyX[L]==84 || greedy.bodyX[L]==0          //snake is also called greedy in this game
            || greedy.bodyY[L]==0 || greedy.bodyY[L]==48 ) //if greedy touch the wall
        {     
            gameover(lcd);
        }

}//end WallMeet

void Snake::checkBodyMeet(N5110 &lcd){
        int i = 0;
        while (i < L - 1){
                if (greedy.bodyY[L-1]==greedy.bodyY[i] && greedy.bodyX[L-1]==greedy.bodyX[i]  )
                        {
                            gameover(lcd);
                        }
                         i++;
                }
        }

void Snake::produceBody(){
       int i = 0;
       while (i < L){
               greedy.bodyX[i]=beginX+i;
               greedy.bodyY[i]=beginY;
               greedy._Joystick[i]=1;
               i++;
       }
       greedy.bodyX[L] = greedy.bodyX[L-1];
       greedy.bodyY[L] = greedy.bodyY[L-1];
       greedy.bodyX[L+1]= greedy.bodyX[L] + 1;
       greedy.bodyY[L+1]= greedy.bodyY[L] + 1;
}//end of produceBody

void Snake::init(int _x, int _y, int _L, int _life){//initalize variables     
    
    initApple();       //initialize apple
    beginX= _x;          
    beginY= _y;
    beginL= _L;
    Life= _life;
    L = _L;           //save variables for further coding
    initApple();   
    produceBody();           
    printf("xog is %d  ", greedy.bodyX[L-1]);
}//end of init

void Snake::draw(N5110 &lcd){
        WallMeet(lcd);   
        checkBodyMeet(lcd);     //checke if greedy touch the wall
            if (Life != 0 ){
                lcd.clear();
                wait(0.15-L*0.001);                
                drawApple(lcd);//produce apple
                lcd.drawRect(0,0,84,48,FILL_TRANSPARENT);//create battlefield
                int i = 0;
                while (i < L){
                              lcd.setPixel(greedy.bodyX[i],greedy.bodyY[i]);
                              i++;
             }  
                lcd.refresh(); 
       }
       
}//end of drawing

//set the joysitick
void Snake::press(Gamepad &pad){
    if( pad.check_event(Gamepad:: A_PRESSED) == true        
            && greedy._Joystick[L-1]!=2) { greedy._Joystick[L-1] =  4 ;}
    if( pad.check_event(Gamepad:: B_PRESSED) == true       
            && greedy._Joystick[L-1]!=3) { greedy._Joystick[L-1] =  1 ;}
    if( pad.check_event(Gamepad:: X_PRESSED) == true        
            && greedy._Joystick[L-1]!=1) { greedy._Joystick[L-1] =  3;}
    if( pad.check_event(Gamepad:: Y_PRESSED) == true       
            && greedy._Joystick[L-1]!=4) { greedy._Joystick[L-1] =  2 ;}
}

void Snake::changeDir(Gamepad &pad){
    
    switch(greedy._Joystick[L-1]){                 
        case 1: greedy.bodyX[L]++; 
                greedy.bodyX[L+1] = greedy.bodyX[L]+1;  break;
        case 2: greedy.bodyY[L]--; 
                greedy.bodyY[L+1] = greedy.bodyY[L]-1;  break;
        case 3: greedy.bodyX[L]--; 
                greedy.bodyX[L+1] = greedy.bodyX[L]-1;  break;
        case 4: greedy.bodyY[L]++; 
                greedy.bodyY[L+1] = greedy.bodyY[L]+1;  break;
    } //change direction

    int i = 0;        //reset body
    while (i < L){
        greedy.bodyX[i]=greedy.bodyX[i+1];
        greedy.bodyY[i]=greedy.bodyY[i+1];
        i++;
    }
    
    //moving with buttons
    press(pad);                     
    d = pad.get_direction();           
    if (d==N && greedy._Joystick[L-1]!=4 ){ greedy._Joystick[L-1] = 2; }  
    if (d==E && greedy._Joystick[L-1]!=3 ){ greedy._Joystick[L-1] = 1; }  
    if (d==W && greedy._Joystick[L-1]!=1 ){ greedy._Joystick[L-1] = 3; }  
    if (d==S && greedy._Joystick[L-1]!=2 ){ greedy._Joystick[L-1] = 4; } 

} // end changeDir

void Snake::update(Gamepad &pad){
     
     if (Life!=0){
    
            printf("x+1 is %d", greedy.bodyX[L+1]);
            printf("y+1 is %d", greedy.bodyY[L+1]);
            printf("dir+1 is %d", greedy._Joystick[L+1]);
            printf("length is %d", L);

            changeDir(pad);
            
            printf("updated ");
            

            if(eatApple()){           
                greedy.bodyX[L] = greedy.bodyX[L+1];
                greedy.bodyY[L] = greedy.bodyY[L+1];
                greedy._Joystick[L] =greedy._Joystick[L-1];
                L++;
                produceApple();   //new apple
                pad.tone(1000.0,0.2);
            }
        }
}

bool Snake:: eatApple(){ 
    pos applePos = getPos();       //get apple's position
    return greedy.bodyX[L-1] == applePos.x && greedy.bodyY[L-1]== applePos.y;
}