#ifndef TESTS_H
#define TESTS_H

#include "N5110.h"
#include "Gamepad.h"
#include "mbed.h"
#include "explorer.h"
#include "item.h"
#include "surface.h"

/** Test Class
* @brief run the code to do the debug process
* @author Yao mochu
* @date May 2020
*/



class test {
 public:
  // Constructor and destructor.
  /**
  * @brief Constructor 
  * @details Non user specified.
  */
  test();
  /**
  * @brief Destructor 
  * @details Non user specified.
  */
  ~test();
  
  // Member methods.
  /**
  * @brief Initalises the Tests.
  * @param _y1 @details the height of lower level
  * @param _y2 @details the height of upper level
  */
  void init(int _y1,int _y2);
   // Member methods.
  /**
  * @brief test the explorer.
  * @param joy_x @details the control of x coordinate
  * @param sprite @details the form of the explorer
  * @param lcd @details the lcd class
  * @param ifjump @details testing the explorer is jumping or not
  * @param jump_height @details the upper height
  * @param y_flag @details the platform to stay
  */
  void test_explorer(float joy_x, int speed, Explorer_sprite sprite, N5110 &lcd, int jump_height);
    // Member methods.
  /**
  * @brief test the item.
  * @param random_x @details the control of x coordinate
  * @param random_y @details the form of the explorer
  * @param lcd @details the lcd class
  */
  void test_item(int random_x, int random_y, N5110 &lcd);
  /**
  * @brief test the item
  * @param lcd @details the lcd class
  */
  void test_surface(N5110 &lcd);
  private:
  item _item;
  Explorer _player;
  Surface _surface;
  int _speed;
  int _jump_height;
  Line line_1_value;
  Line line_2_value;
  Line line_3_value;
  Line line_4_value;
  Line line_5_value;
  Line line_6_value;
  };
#endif
  