#ifndef MENU_H
#define MENU_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Gameengine.h"
/** State for finite state machine struct */
struct State {
  int output;/**< the output state. */
  int next_state[4];/**< the 4 state to change. */ 
};

/** Menu Class

* @1 build three page to choose
* @2 build a good welcome_page
* @3 connect with the gamepad and makesure the game is working
* @date April 27th 2020
* @author Yaomochu
* @code

#include "N5110.h"
#include "Gamepad.h"
#include "mbed.h"
#include "menu.h"

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad gamepad;
menu _menu;

int main() {
  gamepad.init();
  _menu.init(); 
  lcd.init(); 
  lcd.normalMode();      
  lcd.setBrightness(0.5); 
  while(1) {
    
    // clear, refresh lcd and run the menu.
    lcd.clear();  
    _menu.run_engine(lcd, gamepad);   
    lcd.refresh();
    wait(0.01);  
  }     
}  

*@endcode
*/


class Menu {
 public:
     // Constructor and Destructor.
  /**
  * @brief Constructor @details Non user specified.
  */
  Menu();
  /**
  * @brief Destructor @details Non user specified.
  */
  ~Menu();
  // Mutators
  /**
  * @brief Initialises the Menu.
  */ 
  void init();
  /**
  * @brief Runs the menu and a state machine.
  * @param &lcd @details The lcd object from the N5110 class
  * @param &gamepad @details The gamepad object from Gamepad class
  */
  void run_engine(N5110 &lcd, Gamepad &gamepad);
    

    
private:
    void run_game(N5110 &lcd, Gamepad &gamepad); 
    void display_page1(N5110 &lcd, Gamepad &gamepad);
    void display_page2(N5110 &lcd, Gamepad &gamepad);
    void get_input(bool start, bool back, bool b);
    void output(N5110 &lcd, Gamepad &gamepad); 
    Gameengine _game_engine;
    int _input_value;
    int _output;
    int _state;
    };
#endif
    
    