#include "Gameengine.h"
char buffer[15];
// Constructor and destructor.
  Gameengine::Gameengine() {}
 
  Gameengine::~Gameengine() {}

void Gameengine::init() {
    reset_game_engine();
    _start_flag = true;
    srand(time(NULL)); 
    }
    
void Gameengine::reset_game_engine() {
    _item.init();
    _player.init();
    _surface.init(20,40);
    _collision_flag = false;
    _player_score = 0;
    X_flag = false;
    _coordinate.coord.x = 0;
    _coordinate.coord.y = 0;
    }
    
void Gameengine::read_input(Gamepad &gamepad) {
    _coordinate.coord = gamepad.get_mapped_coord();
    X_flag = gamepad.check_event(Gamepad::X_PRESSED); }
    
void Gameengine::check_reset(N5110 &lcd, Gamepad &gamepad) {
    if(_player.get_reset_flag()) {
          gamepad.leds_on();
          lcd.clear();
      for (int i = 0; i < 80; i++) {
      lcd.printString("Try Again",0,2);
      lcd.printString("Score:",0,4);  
      lcd.refresh();
      // dependent on counters.
      wait(0.001);  // Control speed of the sequence.
      sprintf(buffer,"%2d",_player_score); 
      lcd.printString(buffer,15,4); }
      reset_game_engine();
       }
      }

void Gameengine::check_start(N5110 &lcd, Gamepad &gamepad) {
    if(_start_flag == true) { 
     check_reset(lcd, gamepad);} 
    _start_flag = get_start_flag(); 
    }
    
void Gameengine::get_explorer_y(Gamepad &gamepad) {
    set_fall_flag();
    if (_f_flag == true) 
    {
      _player.fall(_f_flag, gamepad);
    } else {
    _player.set_y_coordinate(X_flag, _jump_height, _y_flag); }  
    _f_flag = _player.get_fall_flag(); 
    _player_y = _player.get_y();
    _jump_height = _player.get_jump_height();}
    
void Gameengine::set_fall_flag() {
    if (((set_line_1.right < _player_x) && (_player_x < (set_line_1.left - 5))) && (_y_flag == 0)) {
          _f_flag = true; }
    else if (((set_line_2.right < _player_x) && (_player_x < (set_line_2.left - 5))) && (_y_flag == 0)) {
          _f_flag = true; }
    else if (((set_line_3.right < _player_x) && (_player_x < (set_line_3.left - 5))) && (_y_flag == 0)) {
          _f_flag = true; }
    else if ((_player_x <= 0) && (_player_x >= 80)) {
          _f_flag = true; }
          }
          
void Gameengine::check_collision(Gamepad &gamepad) {
    if ((_player_x == _item.get_item_x() - 5) && (_player_y == _item.get_item_y() - 5)) {  
    _collision_flag = true;
    _player_score++;
    _item.set_item(((rand()%80)+ 5) , ((rand()%80)+ 5));  // use the rand()%m function to generate a number from 80 to 1
    // on a constrained random position.
    gamepad.tone(1000, 0.1);//cause a noise to makesure the coin has collected
    }
    }
    
void Gameengine::generate_lines() {
    _surface.line_1();
    line_1_value = _surface.getline_1();
    _surface.line_2();
    line_2_value = _surface.getline_2();
    _surface.line_3();
    line_3_value = _surface.getline_3();
    _surface.line_4();
    line_4_value = _surface.getline_4();
    _surface.line_5();
    line_5_value = _surface.getline_5();
    _surface.line_6();
    line_6_value = _surface.getline_6(); }
//the start_flag is the flag to make the surface move
//and when the player is playing the start_flag should be false to avoid reset
bool Gameengine::get_start_flag() {
          if(X_flag == true) {
              _start_flag = false; }
              else {_start_flag = true;}
              return _start_flag; }
              
int Gameengine::get_score() {
    return _player_score; 
    }
    
void Gameengine::get_explorer_direction() {_player_direction = _player.get_direction(); }

void Gameengine::get_sprite() {_explorer_sprite = _player.get_explorer_sprite(); }

    
void Gameengine::get_explorer_x() {
    _player_x = _player.get_x();
    _speed = _player.get_speed(); 
    _player.set_x_coordinate(_coordinate.coord.x, _speed, _player_direction); }   

void Gameengine::update_lcd(N5110 &lcd) {
     lcd.drawSprite(_player_x,_player_y,10,10,(int *)_player.get_form(_explorer_sprite));
     lcd.drawSprite(_item.get_item_x(),_item.get_item_y(),5,6,(int*)_item.get_item_form());
     lcd.drawLine(line_1_value.left,line_1_value.y,line_1_value.right,line_1_value.y,FILL_BLACK);
     lcd.drawLine(line_2_value.left,line_2_value.y,line_2_value.right,line_2_value.y,FILL_BLACK);
     lcd.drawLine(line_3_value.left,line_3_value.y,line_3_value.right,line_3_value.y,FILL_BLACK);
     lcd.drawLine(line_4_value.left,line_4_value.y,line_4_value.right,line_4_value.y,FILL_BLACK);
     lcd.drawLine(line_5_value.left,line_5_value.y,line_5_value.right,line_5_value.y,FILL_BLACK);
     lcd.drawLine(line_6_value.left,line_6_value.y,line_6_value.right,line_6_value.y,FILL_BLACK);
     sprintf(buffer,"%2d",_player_score);
     lcd.printString("score",0,0);
     lcd.printString(buffer,30,0); }

void Gameengine::run_engine(N5110 &lcd, Gamepad &gamepad) {
     check_start(lcd, gamepad);
     check_reset(lcd, gamepad);
     read_input(gamepad);
     get_sprite();
     get_explorer_direction();
     get_explorer_y(gamepad);
     get_explorer_x();
     generate_lines();
     check_collision(gamepad);
     update_lcd(lcd);
     _player_score = get_score(); }

     


          
    
    
    
