#include "rocket.h"

// nothing doing in the constructor and destructor
rocket::rocket()
{

}

rocket::~rocket()
{

}

const int the_player[6][11] = { 
// The image shape of rocket
    { 1,0,0,0,1,1,0,0,1,0,0 },
    { 1,1,0,0,0,0,1,0,1,1,0 },
    { 1,1,1,1,1,1,1,1,1,1,1 },
    { 1,1,1,1,1,1,1,1,1,1,1 },
    { 1,1,0,0,0,0,1,0,1,1,0 },
    { 1,0,0,0,1,1,0,0,1,0,0 },
};

const int another_role[6][11] = { 
    { 0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,1,1,0,1,1,1,0,0,0 },
    { 0,1,1,1,1,1,1,1,1,0,0 },
    { 1,1,1,1,1,1,1,1,1,1,1 },
    { 0,1,1,1,1,1,0,1,1,0,0 },
    { 0,0,1,1,0,0,1,1,0,0,0 },
};

void rocket::init(int x) {
    
    _x = x;  // x value on screen is fixed
    _y = HEIGHT/2 - 3;  // y depends on height of screen and height of paddle
    _scale = 5; // scale determines how sensitive the joystick is
    _score = 1; // initiate the score
    _easter = rand() % 100;
}

void rocket::draw(N5110 &lcd) {
    if (_easter < 5) { // there could be 5 percents playing as thor's hammer
        lcd.drawSprite(_x,_y,6,11,(int *)another_role);
    } else {
        lcd.drawSprite(_x,_y,6,11,(int *)the_player); // draw player0 on the screen
    }
}

void rocket::replace(Direction d,float mag,Vector2D mapped) {
    _y -= int(mapped.y * _scale);  // scale is arbitrary, could be changed in future

    // check the y origin to ensure that the paddle doesn't go off screen
    if (_y < 1) {
        _y = 1;
    }
    if (_y > HEIGHT - 7) {
        _y = HEIGHT - 7;
    }
}


void rocket::add_score() { // add score when rocket retrieves the foods
    _score++;
}

void rocket::lose_score() { 
    _score--;
}

int rocket::get_final_score() { 
    return _score;
}

Vector2D rocket::get_locations() { 
    Vector2D p = {_x,_y};
    return p;    
}