#ifndef ENGINE_H
#define ENGINE_H

#include "foods.h"
#include "rocket.h"
#include "the_wall.h"
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"



class Engine
{

public:
    Engine();
    ~Engine();

    void read_input(Gamepad &pad);
    /**
    * @brief Draws every objects on the screen using initiate data/update data
    * @param N5110 
    * @details LCD which diaplay the game
    */
        void init(int wall_width,int wall_gap,int foods_bulk,int speed);
    /**
    * @brief Reads the data input from the joystick
    * @param Gamepad and details Gamepad that holds the parameters of the joystick
    */
    void draw(N5110 &lcd);
    /**
    * @brief Renews positions for all the objects
    * @param Gamepad @details Gamepad that holds the parameters of the joystick
    */
    int get_final_score(); // get score for the incoming events
    void update(Gamepad &pad);
    /** 
    * @brief Gets the score
    * @returns The number of score
    */
    
private:
    void collision(Gamepad &pad);
    void check_score(Gamepad &pad);
    
    the_wall _w0;
    the_wall _w1;
    the_wall _w2;
    the_wall _w3;
    the_wall _w4;
    
    int _wall_width;
    int _wall_gap;
    int _foods_bulk;
    int _velocity;
    
    // x positions of the walls
    int _w0x;
    int _w1x;
    int _w2x;
    int _w3x;
    int _w4x;
    int _rocketx;
    int _foodsx;
    
    rocket _rocket;
    foods _foods;
    
    Direction _d;
    float _mag;
    Vector2D _mapped_coord;


};

#endif