#ifndef OBSTACLE_H
#define OBSTACLE_H
 
#include "Gamepad.h"
#include "mbed.h"
#include "N5110.h"
/** The bullet Class
* @brief This program define the obstacle
* @author Yang Hongxiao
* @date 15/5/2020
*/

 
class Obstacle{
    
public:
/** Constructor */
Obstacle();
/** Destructor */
~Obstacle();
/** Set the inital value
 * @param the value of the Obstacle pos.x (int _x),the value of the Obstacle pos.y (int _y),
 */                
void init();
/**draw the Obstacle
 * @param the screen(N5110 &lcd)
 */
void draw(N5110 &lcd);   
/** Get the obstacle position
 * @return the current position
 */  
Vector2D get_obstacle_pos();
/** Get the new obstacle position
 * @return the current position of the new obstacle
 */  
void new_obstacle();
            

       
private:    
    int _x;
    int _y;
    
};
#endif