#include "Control.h"

Control::Control()
{

}

Control::~Control()
{

}

void Control::init(int platform_w,int platform_h,int r,int vv)
{
   
    _platform_w = platform_w;
    _platform_h = platform_h;
    _r = r;
    _vv = vv;
    _length =  45;
    _p.init(_length,_platform_h,_platform_w);
    _o.init();
    _bullet.init(_r,_vv);
}

void Control::read_input(Gamepad &pad)
{
    _d = pad.get_direction();
    _mag = pad.get_mag();
}

void Control::draw(N5110 &lcd)
{

    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    print_scores(lcd);
    _p.draw(lcd);
    _bullet.draw(lcd);
    _o.draw(lcd);
}

void Control::update(Gamepad &pad)
{
    check_goal(pad);
    _p.update(_d,_mag);
    _bullet.update();
    check_wall_collision(pad);
    check_platform_collisions(pad);
    check__obstacle_collisios(pad);
}

void Control::check_wall_collision(Gamepad &pad)
{
    Vector2D bullet_pos = _bullet.get_pos();
    Vector2D bullet_velocity = _bullet.get_velocity();

    if (bullet_pos.y <= 1) {  
        bullet_pos.y = 1;  
        bullet_velocity.y = -bullet_velocity.y;
        pad.tone(550.0,0.1);
    }
  
    else if (bullet_pos.x + _r >= (WIDTH-1) ) { 
        bullet_pos.x = (WIDTH-1) - _r;  
       bullet_velocity.x = -bullet_velocity.x;

        pad.tone(550.0,0.1);
    }

    else if (bullet_pos.x <= 1) { 
        bullet_pos.x = 1; 
        bullet_velocity.x = -bullet_velocity.x;
        pad.tone(550.0,0.1);
    }
    _bullet.set_velocity(bullet_velocity);
    _bullet.set_pos(bullet_pos);
}

void Control::check_platform_collisions(Gamepad &pad)
{
    Vector2D bullet_pos = _bullet.get_pos();
    Vector2D bullet_velocity = _bullet.get_velocity();

    Vector2D p_pos = _p.get_pos();

    if (
        (bullet_pos.y >= p_pos.y) &&                  
        (bullet_pos.y <= p_pos.y + _platform_h) && 
        (bullet_pos.x >= _length) && 
        (bullet_pos.x <= _length + _platform_w)
    ) {
        bullet_pos.y = _length+ _platform_h;
        bullet_velocity.y = -bullet_velocity.y;
        pad.tone(1000.0,0.1);
              
    }

    _bullet.set_velocity(bullet_velocity);
    _bullet.set_pos(bullet_pos);
}
void Control::check__obstacle_collisios(Gamepad &pad)
{
  
    Vector2D bullet_pos = _bullet.get_pos();
    Vector2D bullet_velocity = _bullet.get_velocity();
    Vector2D p_pos = _p.get_pos();
    Vector2D o_pos= _o.get_obstacle_pos();

    if ((bullet_pos.y >= o_pos.y) && 
        (bullet_pos.y <= o_pos.y + 2) &&
        (bullet_pos.x >= o_pos.x) && 
        (bullet_pos.x <= o_pos.x + 20) ){
       
        bullet_velocity.y = -bullet_velocity.y;
   
        pad.tone(1000.0,0.1);
        _p.add_score();
        _o.new_obstacle();
    }

    _bullet.set_velocity(bullet_velocity);
    _bullet.set_pos(bullet_pos);
}

void Control::check_goal(Gamepad &pad)
{
   
    Vector2D bullet_pos = _bullet.get_pos();
    
    if (bullet_pos.y > WIDTH) {
      
        _bullet.init(_r,_vv);
        pad.tone(1500.0,0.5);
        pad.leds_on();
        wait(0.5);
        pad.leds_off();
    }
}

void Control::print_scores(N5110 &lcd)
{
    int p_score = _p.get_score();
    char buffer1[14];
    sprintf(buffer1,"%2d",p_score);
    lcd.printString(buffer1,WIDTH/2 + 22,1); 
    
}