#ifndef BULLET_H
#define BULLET_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Platform.h"
/** The bullet Class
* @brief This program define the bullets
* @author Yang Hongxiao
* @date 15/5/2020
*/

class Bullet
{

public:
/** Constructor */
Bullet();
/** Destructor */
~Bullet();
/** Set the inital value
 * @param the value of the bullet size (int r),the value of the bullet speed (int vv),
 */
    void init(int r,int vv);
/** draw the bullet
 * @param the screen(N5110 &lcd)
 */
    void draw(N5110 &lcd);
/** Set the update value
 * @param none
 */
    void update();
/** Set the velocity value
 * @param the velocity(Vector2D v)
 */    
    void set_velocity(Vector2D v);
/** Get the velocity
 * @return the current velocity
 */    
    Vector2D get_velocity();
 /** Get the position
 * @return the current position
 */    
    Vector2D get_pos();
/** Set the position value
 * @param the position(Vector2D p)
 */      
    void set_pos(Vector2D p);
    
private:

    Vector2D _velocity;
    int _r;
    int _x;
    int _y;
};
#endif