/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name:  Yang Hongxiao
Username:   el17hy
Student ID Number:   201199678
Date:    15/5/2020
*/
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Control.h"
#include "Bullet.h"
#include "Platform.h"
#include "Obstacle.h"


#define PLATFORM_W 10
#define PLATFORM_H 2
#define R 2          //the size of the ball
#define VV 3         //the velocity of the ball



struct UserInput {
    Direction d;
    float mag;
};
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Bullet bullet;
Platform p;
Control con;


void init();
void bullet_init();
void render();
void welcome();
void introduction();
void introduction1();



int main()
{


    int fps = 8;  
while(1){
    init();     
    welcome(); 
    introduction();      //the introduction of the game
    introduction1();
    render(); 
    wait(1.0f/fps); 
   
while (1){
  
        con.read_input(pad);
        con.update(pad);
        render();
        wait(1.0f/fps);
        
         if( pad.check_event(Gamepad::B_PRESSED) == true) {
             lcd.refresh();
             wait(1.0f/fps);
             break;
        }
        }
    }
}

void init()
{

    lcd.init();
    pad.init();
    con.init(PLATFORM_W,PLATFORM_H,R,VV);

}

void render()
{
    lcd.clear();  
    con.draw(lcd);
    lcd.refresh();
}

void welcome() {
    
    lcd.printString("     Shoot!    ",0,1);
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();

    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 
}
void introduction() {
    lcd.clear();
    lcd.printString("  shoot the  ",0,1);
    lcd.printString("   obstacle  ",0,2);
    lcd.printString("   Press A   ",0,3);
    lcd.printString("  to continue ",0,4);
    lcd.refresh();
    while ( pad.check_event(Gamepad::A_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 
}
void introduction1() {
    lcd.clear();
    lcd.printString("  If you want ",0,1);
    lcd.printString("   to  quit  ",0,2);
    lcd.printString("   Press B   ",0,3);
    lcd.printString("   to quit  ",0,4);
    lcd.refresh();

    while ( pad.check_event(Gamepad::A_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 
}
