#ifndef PLATFORM_H
#define PLATFORM_H


#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
/** The bullet Class
* @brief This program define the bullets
* @author Yang Hongxiao
* @date 15/5/2020
*/


class Platform
{
public:
/** Constructor */
Platform();
/** Destructor */
~Platform();
/** Set the inital value
 * @param the y_position of the platformthe(int y), the value of the platform width (int w),the value of the platform height (int h),
 */
    void init(int y,int h,int w);
/** draw the platform
 * @param the screen(N5110 &lcd)
 */
    void draw(N5110 &lcd);
/** Set the update value
 * @param Direction (Direction d),magnitude(float mag)
 */
    void update(Direction d,float mag);
/** Get the position
 * @return the current position
 */
    Vector2D get_pos();
/** Add the score
 * @return the score++
 */
    void add_score();
/** Get the score
 * @return the current score
 */
    int get_score();


private:

    int _h;     //the height of the platform
    int _w;     //the width of the platform
    int _x;
    int _y;
    int _vv;     //the speed of the platform
    int _score;
};
#endif