#ifndef CONTROL_H
#define CONTROL_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bullet.h"
#include "Platform.h"
#include "Obstacle.h"
/** The control Class
* @brief This program define the control system
* @author Yang Hongxiao
* @date 15/5/2020
*/

class Control
{

public:
/** Constructor */
    Control();
/** Destructor */
    ~Control();
/** Set the inital value
 * @param the value of the platform width (nt platform_w),the value of the platform height (int platform),
 * the value of bullet size(int r),the value of bullet spped(int vv),
 */
    void init(int platform_w,int platform_h,int r,int vv);
 /** Get the direction and magnitude
 * @return the direction and magnitud
 */   
    void read_input(Gamepad &pad);
/** Set the update value
 * @param none
 */
    void update(Gamepad &pad);
/** draw the bullet,platform,obstacle,the screen edge
 * @param the screen(N5110 &lcd)
 */
    void draw(N5110 &lcd);
    
    
private:

    void check_wall_collision(Gamepad &pad);
    void check_platform_collisions(Gamepad &pad);
    void check_goal(Gamepad &pad);
    void print_scores(N5110 &lcd);
    void check__obstacle_collisios(Gamepad &pad);
    
    Platform _p;
    Obstacle  _o;
    Bullet _bullet;

    int _platform_w;
    int _platform_h;
    int _r;
    int _vv;
    int _length;

 
    Direction _d;
    float _mag;

};

#endif