#ifndef ROONEYENGINE_H
#define ROONEYENGIN_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Rooney.h"
#include "Ball.h"

class RooneyEngine{
    public:
    // Constructor and destructor.
    /**
    * @brief Constructor @details Non user specified.
    */
    RooneyEngine();
    /**
    * @brief Destructor @details Non user specified.
    */
    ~RooneyEngine();
    void init();
    void reset();
    void check_reset(N5110 &lcd, Gamepad &gamepad);
    void check_start(N5110 &lcd, Gamepad &gamepad);
    void check_collision(Gamepad &gamepad);
    void get_score();
    void get_sprite();
    void update_lcd(N5110 &lcd);
    void run_engine(N5110 &lcd, Gamepad &gamepad);
    bool get_reset_flag();
    bool get_start_flag();
    void get_ronney_x(Gamepad &gamepad);
    private:
    int _player_x;
    int _player_y;
    int _x;
    int _y;
    bool _collision_flag;
    bool _start_flag;
    bool _reset_flag;
    int _speed;
    int _player_score;
};
#endif
    