#ifndef MENU_H
#define MENU_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "RooneyEngine.h"

struct State {
    int output;
    int next_state[4]; };
        
class Menu {
    public:
    // Constructor and destructor.
    /**
    * @brief Constructor @details Non user specified.
    */
    Menu();
    /**
    * @brief Destructor @details Non user specified.
    */
    ~Menu();
    void init();
    void run_engine(N5110 &lcd, Gamepad &gamepad);
    void run_game(N5110 &lcd, Gamepad &gamepad);
    
    private:
    void display_page1(N5110 &lcd, Gamepad &gamepad);
    void display_page2(N5110 &lcd, Gamepad &gamepad);
    void display_page3(N5110 &lcd, Gamepad &gamepad);
    void get_output(N5110 &lcd, Gamepad &gamepad);
    void get_input(bool start, bool back, bool x);
    int _output;
    int _state;
    int _input;
    RooneyEngine _engine;
    };
    #endif
    