#include "explorer.h"
//the explorer.cpp need to defined the module and movement of the explorer including the restarted point 
int move_right_sprite[10][10] =   { 
  { 0,0,0,1,1,1,0,0,0,0 },
  { 0,0,0,1,0,1,0,0,0,0 },
  { 0,0,0,1,1,1,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,0,0 },
  { 0,0,1,1,1,1,1,0,0,0 },
  { 0,0,1,0,1,0,0,0,0,0 },
  { 0,0,0,0,1,0,0,0,0,0 },
  { 0,0,0,0,1,1,1,0,0,0 },
  { 0,0,0,1,0,0,0,1,0,0 },
  { 1,0,1,0,0,0,0,0,1,0 },
};

int move_left_sprite[10][10] =   { 
  { 0,0,0,1,1,1,0,0,0,0 },
  { 0,0,0,1,0,1,0,0,0,0 },
  { 0,0,0,1,1,1,0,0,0,0 },
  { 0,0,1,0,1,0,0,0,0,0 },
  { 0,0,1,1,1,1,1,0,0,0 },
  { 0,0,0,0,1,0,1,0,0,0 },
  { 0,0,0,0,1,0,0,0,0,0 },
  { 0,0,0,1,1,0,0,0,0,0 },
  { 0,0,1,0,0,1,0,0,0,0 },
  { 0,1,0,0,0,0,1,0,0,0 },
};

int stand_right_sprite[10][10] =   { 
  { 0,0,0,1,1,1,0,0,0,0 },
  { 0,0,0,1,0,1,0,0,0,0 },
  { 0,0,0,1,1,1,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,0,0 },
  { 0,0,1,1,1,1,1,0,0,0 },
  { 0,0,1,0,1,0,0,0,0,0 },
  { 0,0,0,0,1,0,0,0,0,0 },
  { 0,0,0,0,1,0,0,0,0,0 },
  { 0,0,0,1,0,1,0,0,0,0 },
  { 0,0,0,1,0,1,0,0,0,0 },
};

int stand_left_sprite[10][10] =   { 
  { 0,0,0,1,1,1,0,0,0,0 },
  { 0,0,0,1,0,1,0,0,0,0 },
  { 0,0,0,1,1,1,0,0,0,0 },
  { 0,0,1,0,1,0,0,0,0,0 },
  { 0,0,1,1,1,1,1,0,0,0 },
  { 0,0,0,0,1,0,1,0,0,0 },
  { 0,0,0,0,1,0,0,0,0,0 },
  { 0,0,0,0,1,0,0,0,0,0 },
  { 0,0,0,1,0,1,0,0,0,0 },
  { 0,0,0,1,0,1,0,0,0,0 },
};

Explorer::Explorer() {} 

Explorer::~Explorer() {}
void Explorer::init() {
  _f_flag = false;
  _player_direction = right;
  _r_flag = false;
  _speed = 0;//the player is standing at first.
  _jump_height = 0;
  }

void Explorer::set_x_coordinate(float joy_x, int speed, Player_direction direction)
{
  //this process is to set x and make sure the player can move          
  _player_direction = direction;
  _speed = speed;
  if (joy_x < float(-0.05)) {
    _speed = _speed--;//
    _player_direction = left;
    _explorer_sprite = Move_left;//makesure the value is the Move_left value in the enum 
  //now x is moving to the right than add to the X position
  } else if (joy_x > float(0.05)) {
    _speed = _speed++;
    _player_direction = right; 
    _explorer_sprite = Move_right;//makesure the value is the Move_right value in the enum  
  } else if (_player_direction == right) {  
    _explorer_sprite = Stand_right;// not moving so equals to enum Stand_right.
  } else { 
    _explorer_sprite = Stand_left;//the least situation is equals to enum Stand_right.
  }      
  _x = 0.5*_speed + 30;//this equation decides how fast the player move later I will update differnet modes to choose different speed
}
//this function is easy to understand because this is just choosing different sprite according to the direction
int * Explorer::get_form(Explorer_sprite sprite){
  if (sprite == Move_right) {
    return *move_right_sprite;
  } else if (sprite == Move_left) {
    return *move_left_sprite;
  } else if (sprite == Stand_left) {
    return *stand_right_sprite;
  } else {
    return *stand_left_sprite;
  }
}

Player_direction Explorer::get_direction() {
  return _player_direction;
}    

Explorer_sprite Explorer::get_explorer_sprite() {
  return _explorer_sprite;
}
    
void Explorer::set_y_coordinate(bool ifjump, int jump_height, int y_flag) {
  _jump_height = jump_height;
  _y_flag = y_flag;
  if (ifjump && _jump_height < 40) {  
    _jump_height = 30; }
  if (_jump_height !=0) _speed--;  // Keep falling until not jumping.
  if ((_line_4.left <= _x - 5) && (_line_4.right >= _x)){
    _y_flag = 1;}
    else if ((_line_5.left <= _x - 5) && (_line_5.right >= _x)) {
    _y_flag = 1;}
    else if ((_line_6.left <= _x - 5) && (_line_6.right >= _x)) {
    _y_flag = 1;}
    else if ((_line_1.left <= _x) && (_line_1.right >= _x)){
    _y_flag = 0; }
    else if ((_line_2.left <= _x) && (_line_2.right >= _x)){
    _y_flag = 0;}
    else if ((_line_3.left <= _x) && (_line_3.right >= _x)){
    _y_flag = 0;}    
  if (_y_flag == 1 && ifjump) { 
    _platform = 5;
  } else if (_y_flag == 0) {
    _platform = 25;
  }
  _y = _platform - 0.5*_jump_height;  
}
  
int Explorer::get_y() {
  return _y;
}

int Explorer::get_x() {
  return _x;
}
  
int Explorer::get_speed() {
  return _speed;
}

int Explorer::get_y_flag() {
    return _y_flag; 
}
  
int Explorer::get_jump_height() {
  return _jump_height;
}

void Explorer::reset_flag(bool flag) {
   if (flag) {
    _r_flag = true;
  } else {
    _r_flag = false;
  }
}

 
void Explorer::fall(bool f_flag, Gamepad &gamepad) { 
  _f_flag = f_flag;  // decending equation
  if (_f_flag == true) { 
    _y++; }
  else if(_y == 80) {  // Stop falling function 
    _f_flag = false;
    _r_flag = true;
    gamepad.tone(1000, 0.05);
    wait(0.01);
  }
}

bool Explorer::get_fall_flag() {
  return _f_flag;
}

bool Explorer::get_reset_flag() {
  return _r_flag;
}    