#ifndef GAMEENGINE_H
#define GAMEENGINE_H


#include "N5110.h"
#include "mbed.h"
#include "Gamepad.h"
#include "item.h"
#include "explorer.h"
#include "surface.h"
#include <cstdlib>
#include <ctime>

/** Coordinate struct */
struct Coordinate {
  Vector2D coord; /**< Vector 2D for joystick coords */ 
  };

/** Gameengine Class
* @1 make the whole explorer game run and set the score the reset process
* @2 cheak the collision and the reset or fall flag
* @3 draw on the lcd screen and load the gamepad controll
* @date April 24th 2020
* @author Yaomochu

@code

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Gameengine.h"

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad gamepad;
Gameengine _game_engine;

bool _start_flag;
int _player_score;

int main() {
    _game_engine.init();
    while(1) {
        _game_engine.check_reset(lcd, gamepad);
        _start_flag = _game_engine.get_start_flag();
        _game_engine.read_input(gamepad);
        _game_engine.get_sprite();
        _game_engine.get_explorer_direction();
        _game_engine.get_explorer_y(gamepad);
        _game_engine.get_explorer_x();
        _game_engine.generate_lines();
        _game_engine.check_collision(gamepad);
        _game_engine.update_lcd(lcd);
        _player_score = _game_engine.get_score();
        _game_engine.run_engine(lcd, gamepad); 
        }
}

@endcode
*/

class Gameengine {
 // Constructor and destructor.
public:
// Constructor and destructor.
  /**
  * @brief Constructor 
  * @details Non user specified.
  */
Gameengine();
/**
  * @brief Destructor 
  * @details Non user specified.
  */
~Gameengine();
  // Mutators.
  /**
  * @brief Initalises the Gameengine.
  */ 
    void init();
  /**
  * @brief reset the gameengine.
  */ 
    void reset_game_engine();
  /**
  * @brief get the coordinate and the button_flag.
  * @param &gamepad @details The gamepad object from Gamepad class.
  */ 
    void read_input(Gamepad &pad);
  /**
  * @brief check and flesh the reset flag.
  * @param &gamepad @details The gamepad object from Gamepad class.
  * @param &lcd @details The lcd object from the N5110 class
  */ 
    void check_reset(N5110 &lcd, Gamepad &gamepad);
  /**
  * @brief check and flesh the collision flag.
  * @param &gamepad @details The gamepad object from Gamepad class.
  */
    void check_collision(Gamepad &gamepad);
  /**
  * @brief check and flesh the start flag.
  * @param &gamepad @details The gamepad object from Gamepad class.
  * @param &lcd @details The lcd object from the N5110 class
  */ 
    void check_start(N5110 &lcd, Gamepad &gamepad);
  /**
  * @brief set the fall flag for engine.
  */ 
    void set_fall_flag();
  /**
  * @brief get the start flag.
  */ 
    bool get_start_flag();
  /**
  * @brief generate the upper and lower lines.
  */ 
    void generate_lines();
  /**
  * @brief get the player score.
  */ 
    int  get_score();
  /**
  * @brief get the player's direction.
  */ 
    void get_explorer_direction();
  /**
  * @brief get the item and explorer sprite.
  */ 
    void get_sprite();
  /**
  * @brief get player's y.
  * @param &gamepad @details The gamepad object from Gamepad class.
  */ 
    void get_explorer_y(Gamepad &gamepad);
  /**
  * @brief get player's y.
  */
    void get_explorer_x();
  /**
  * @brief Updates the LCD display.
  * @param &lcd @details The lcd object from the N5110 class.
  */
    void update_lcd(N5110 &lcd);
  /**
  * @brief run the game.
  */
    void run_engine(N5110 &lcd, Gamepad &gamepad);


private:
Coordinate _coordinate;
item _item;
Explorer _player;
Surface _surface;
bool X_flag;
int _player_x;
int _player_y;
bool _collision_flag;
bool _f_flag;
bool _r_flag;
bool _start_flag;
int  _speed;
int _jump_height;
int _player_score;
bool _y_flag;
Line set_line_1;
Line set_line_2;
Line set_line_3;
Line line_1_value;
Line line_2_value;
Line line_3_value;
Line line_4_value;
Line line_5_value;
Line line_6_value;
Player_direction _player_direction;
Explorer_sprite _explorer_sprite; 
};
#endif
  

