#ifndef EXPLORER_H
#define EXPLORER_H


#include "mbed.h"
#include "Gamepad.h"
#include "surface.h"
//use the enum to define the value we need for the explorer
enum Explorer_sprite {Move_right,Move_left,Stand_left, Stand_right};
//we have four sprite form so we can define the sprite on the screen by using these enum
//the explorer's direction
enum Player_direction {right,left};

/** Explorer Class
* @the explorer file has three functions
* @ 1 the movement of a explorer to jump and move in left or right direction
* @ 2 check fallen and collision
* @ 3 reset the game
* @ date April 15th 2020
* @ author Yaomochu
* @code

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "explorer.h"
#include <cstdlib>
#include <ctime>

Gamepad gamepad;
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Explorer _player;

int _player_x; 
int _player_y;
bool _f_flag;
bool _start_flag;
int _speed;
int _jump_height;
int _y_flag;
Player_direction _player_direction;
Explorer_sprite _explorer_sprite;  

int main() {
  _player.init();
  _start_flag = true;
  while(1) {
    
    // Y coordinate
    if (_f_flag == true) 
    {
      _player.fall(_f_flag, gamepad);
    } else {
    _player.set_y_coordinate(false, _jump_height, _y_flag}  
    _f_flag = _player.get_fall_flag(); 
    _player_y = _player.get_y();
    _jump_height = _player.get_jump_height();
    
    // X coordinate
    _player_x = _player.get_x();
    _speed = _player.get_speed(); 
    _player.set_x_coordinate(1, _speed, _player_direction); 
 
        
    //change in to a new direction.
    _player_direction = _player.get_direction();

    lcd.drawSprite(_player_x,_player_y,10,10,(int *)_player.get_form(_explorer_sprite));//draw the player
  }  
}

* @endcode
*/

class Explorer {
 public:
  // Constructor and destructor.
  /**
  * @brief Constructor @details Non user specified.
  */
 Explorer();
  /**
  * @brief Destructor @details Non user specified.
  */
 ~Explorer();
void init();

  // Mutators.
  /**
  * @brief Sets the X coordinate of the Explorer.
  * @param joy_x @details The horizontal value of the joystick x.
  * @param speed @details The player's speed to move.
  * @param Player_direction direction @details The current direction the skater is facing from the enum class
  */
void set_x_coordinate(float joy_x, int speed, Player_direction direction);
  /** 
  * @brief Sets the Y coordinate of the Explorer.
  * @param ifjump @details B boolean flag that is true only if the B button is pressed
  * @param jump_height @details the height when player jumps and which level to stay
  * @param y_flag @details the upper or lower surface
  * @param platform @details the y for the platform
  */
void set_y_coordinate(bool ifjump, int jump_height, int y_flag);
  /** 
  * @brief get y coordinate.
  * @returns The y coordinate of the explorer
  */
int get_y();
   /** 
  * @brief get x coordinate.
  * @returns The x coordinate of the explorer
  */
int get_x();
  /** 
  * @brief get speed.
  * @returns The moving speed of the explorer
  */
int get_speed();
   /** 
  * @brief get jump height.
  * @returns the increasing height of the explorer.
  */
int get_jump_height();
   /** 
  * @brief get the level of the player.
  * @returns if the player is on upper or lower platform.
  */
int get_y_flag();
   /** 
  * @brief get player's direction.
  * @returns direction of the player.
  */
Player_direction get_direction();
   /** 
  * @brief get sprite.
  * @returns four different sprites.
  */
Explorer_sprite get_explorer_sprite();
   /** 
  * @brief get the players form and print on the screen (same as the item file)
  * @returns the sprite of the explorer
  */
int * get_form(Explorer_sprite sprite);
    /** 
  * @brief get the fall flag
  * @param &gamepad @details The gamepad object from Gamepad class.
  * @param f_flag @details the fall flag.
  */
void fall(bool f_flag, Gamepad &gamepad);
    /** 
  * @brief get the reset flag
  * @param flag @details the reset flag.
  */
void reset_flag(bool flag);
/**
  * @brief Gets the fall flag.
  * @returns The fall flag of the explorer.
  */
bool get_fall_flag();
/**
  * @brief Gets the reset flag.
  * @returns The reset flag of the explorer.
  */
bool get_reset_flag();
 
 private:
    
int _x;
int _y;
int _speed;
int _jump_height;
bool _f_flag;
bool _r_flag;
int _platform;
int _y_flag;
Line _line_1;
Line _line_2;
Line _line_3;
Line _line_4;
Line _line_5;
Line _line_6;
Player_direction _player_direction;
Explorer_sprite _explorer_sprite;   
};
#endif
