#ifndef SNAKE_H
#define SNAKE_H

#include "Food.h"
#include <math.h>
#include <stdlib.h>
#include "Gamepad.h"
#include "mbed.h"
#include "N5110.h"

/** pos struct */
struct snakePart{
    
    char _x[4000];/**< char for x value */
    char _y[4000];/**< char for y value */
    char _dir[4000];/**< char for dir value */
    
    };

//libraies including

/** Snake Class 
 * @brief Does nothing useful 
 * @author Du Xianjie 
 * @date May, 2019 
 */ 

class Snake{
    
    public:
    
        /** Constructor */ 
        Snake();
        /** Destructor */ 
        ~Snake();
        
        /** Set the draw
         * @param the figure (N5110 &lcd) 
         */
        void draw(N5110 &lcd);
        /** Set the gamepad
         * @param screen (Gamepad &pad) 
         */
        void update(Gamepad &pad);
        /** Set the deadsnake
         * @param dead snake(N5110 &lcd) 
         */
        void deadSnake(N5110 &lcd);
        /** Set the inital snake
         * @param initial snake(int x, int y, int lenght,int _live) 
         */
        void init(int x, int y, int lenght,int _live);
        /** Set the point
         * @param food point() 
         */
        void addPoint();
        /** Check the wall collision
         * @param collision(N5110 &lcd) 
         */
        void checkWallCollision(N5110 &lcd);
        /** Check the tail collision
         * @param collision(N5110 &lcd) 
         */
        void checkTailCollision(N5110 &lcd);
        /** Show the score
         * @param score(N5110 &lcd) 
         */
        void drawScore(N5110 &lcd);
        /** Show the length
         * @return length(_length) 
         */
         
        int _length;
        int live;
        int waitTime;
    
        float waitCount;
       
          
    private:
        
        
        int _speed;
        int _direction;
        
        int startx;
        int starty;
        int startl;
        int x;
        
        Direction d;
        Food _food;
        
        
};//definition of variable and functions
    
    #endif
