#ifndef FOOD_H
#define FOOD_H


#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


/**Foodpos struct */
struct Foodpos{
    int x;  /**< Food X coordinate*/
    int y;  /**< Food Y coordinate*/
    
    };


/** My Food Class
* @brief Class for defining Food properties and states
* @author Li Saiwen
* @date May, 2019
*/

class Food{
    
    
    public:
            
            /** Constructor */
            Food();
            
            /** Destructor */
            ~Food();
            
            /** initial Food coordinate
            */
            void init();
            
            /** draw Food according to the food coordinate
             * @param lcd the subclass of N5110
            */
            void drawfood(N5110 &lcd);
            
            /** create food on the map randomly 
            */
            void createfood();
            
            /** Gets polar coordinates of the Food
             * @returns a struct contains Food x coordinate and Food y coordinate
            */
            Foodpos returnPos();
    
    
    private:    
    
    
};
#endif