///////// pre-processor directives ////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Snake.h"
#include "Engine.h"
#include "Finger.h"

/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Snake snake;
Engine engine;
Finger finger;

///////////// prototypes ///////////////
void init();
void run();
void over();

///////////// functions ////////////////
int main()
{
    int fps = 8;  // frames per second
    snake.hscore = 0;  //initialise the highest record
    lcd.init();
    while(1){    
      init();
      pad.tone(900.0,0.5); // Start-up sound
      engine.welcome(pad,lcd);  // show welcome display, waiting for the user to start
      engine.menu(pad,lcd);  // show the select display, waiting for the user to select
    // choose game and game loop
    if(engine.game == 0){
      while (snake.over == 0) {
        run(); // run snake game
        while (pad.check_event(Gamepad::START_PRESSED) == true){
            engine.pause(pad,lcd); // pause the game
        }
        wait(engine.p/fps);  // and wait for one frame period
      }
     over();  // show gameover display, waiting for the user to restart
     }else if(engine.game == 1){
         finger.run(lcd,pad); // run the finger-geuss game
         }
    }
}

// this function draws each frame on the LCD
void run()
{
    // clear screen, re-draw and refresh
    lcd.clear(); // lear the lcd
    int length = snake.get_length(); // get length 
    int direction = engine.get_direction(pad); // get direction
    snake.check_eat(pad); // check if eat
    snake.update(direction,length); // update the position of snake
    snake.draw(lcd,length); // draw the snake
    snake.check_over(lcd); // check if the game is over
    lcd.refresh(); // refresh the lcd
}

// initialies all classes and libraries
void init()
{
    // need to initialise Gamepad, engine, sanke and clear the screen
    pad.init(); // initialise the Gamepad
    snake.init(2,3); // set the size = 2 and length = 3
    engine.init(); // initialise the engine
    finger.init(); // initialise the figner game
    lcd.clear(); // initialise the lcd
}

//gameover screen
void over()
{
    int s = snake.get_score(); // get the scores to show at the gameover display
    int hs = snake.hscore; // get the heighest record to show at the gameover display
    engine.gameover(pad,lcd,s,hs); // show the gameover display

}