#ifndef FINGER_H
#define FINGER_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Finger class

@brief Class for the finger-guess game
@brief It was the game I initially wrote
@brief However, I thought this game was too easy and then changed to the sanke game
@brief But I still want to add this game for a extra scene

@author Qi Minghong

@date April 2019

@code
///////// pre-processor directives ////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Snake.h"
#include "Engine.h"
#include "Finger.h"

/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Snake snake;
Engine engine;
Finger finger;

///////////// prototypes ///////////////
void init();
void run();
void over();

///////////// functions ////////////////
int main()
{
    int fps = 8;  // frames per second
    snake.hscore = 0;
    lcd.init();
    while(1){    
      init();
      pad.tone(900.0,0.5);
      engine.welcome(pad,lcd);  // show welcome display, waiting for the user to start
      engine.menu(pad,lcd);  // show the select display, waiting for the user to select
    // choose game and game loop
    if(engine.game == 0){
      while (snake.over == 0) {
        run(); // run the snake game
        while (pad.check_event(Gamepad::START_PRESSED) == true){
            engine.pause(pad,lcd); // pause the game
        }
        wait(engine.p/fps);  // and wait for one frame period
      }
     over();  // show gameover display, waiting for the user to restart
     }else if(engine.game == 1){
         finger.run(lcd,pad); // run the finger-geuss game
         }
    }
}

// this function draws each frame on the LCD
void run()
{
    // clear screen, re-draw and refresh
    lcd.clear();
    int length = snake.get_length();
    int direction = engine.get_direction(pad);
    snake.check_eat(pad);
    snake.draw(lcd,length);
    snake.update(direction,length);
    snake.check_over(lcd);
    lcd.refresh();
}

// initialies all classes and libraries
void init()
{
    // need to initialise LCD and Gamepad
    pad.init();    
    snake.init(2,3);
    engine.init();
    finger.init();
    lcd.clear();
}

//gameover screen
void over()
{
    int s = snake.get_score(); // get the scores to show at the gameover display
    int hs = snake.hscore;
    engine.gameover(pad,lcd,s,hs);

}
@endcode
*/ 

class Finger
{

public:
    /** Constructor */
    Finger();
    /** Destructor */
    ~Finger();
    /** Initialise the components of snake
    *
    *   This function gets the length of the snake.
    */
    void init();
    /** Draw the finger and scores
    *
    *   This function draws the finger and scores.
    *   @param  lcd - N5110 library
    *   @param  length - the length of the snake
    */
    void draw(N5110 &lcd,Gamepad &pad);
    /** Run the game
    *
    *   This function check which wins and adds socres.
    *   @param  lcd - N5110 library
    *   @param  length - the length of the snake
    */
    void run(N5110 &lcd,Gamepad &pad);


private:
    int _score1;
    int _score2;
    int _finger1;
    int _finger2;
    int c;

};
#endif