#include "Finger.h"

// nothing doing in the constructor and destructor
Finger::Finger()
{

}

Finger::~Finger()
{

}
// draw the paper
int paper[15][15] = {
    {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
};
// draw the stone
int stone[15][15] = {
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
};
// draw the scissors
int scissors[15][15] = {
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,0,0,0,0,0,0,0,0,0,0,0,1,0},
    {0,0,1,0,0,0,0,0,0,0,0,0,1,0,0},
    {0,0,0,1,0,0,0,0,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,0,0,0,1,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,0,1,0,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
    {0,0,0,1,1,1,1,0,1,1,1,1,0,0,0},
    {0,0,1,0,0,0,1,0,1,0,0,0,1,0,0},
    {0,1,0,0,0,0,1,0,1,0,0,0,0,1,0},
    {0,1,0,0,0,1,0,0,0,1,0,0,0,1,0},
    {0,1,0,0,0,1,0,0,0,1,0,0,0,1,0},
    {0,0,1,1,1,0,0,0,0,0,1,1,1,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
};

// initialise socres and fingers
void Finger::init(){
    _finger1 = 1;
    _finger2 = 0;
    _score1 = 0;
    _score2 = 0;
}

// draw fingers and scores
void Finger::draw(N5110 &lcd,Gamepad &pad){
    lcd.drawRect(WIDTH/2 - 1,0,1,HEIGHT,FILL_TRANSPARENT);
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    lcd.drawRect(0,0,WIDTH,20,FILL_TRANSPARENT);
    lcd.printString(" You",6,4);
    lcd.printString(" Com",50,4);
    char buffer1[5];
    // print message to buffer
    sprintf(buffer1," %d",_score1);
    char buffer2[5];
    sprintf(buffer2," %d",_score2);
    lcd.printString(buffer1,12,3);
    lcd.printString(buffer2,56,3);
    // select the finger
    if (_finger1 == 0){
    lcd.drawSprite(13,3,15,15,(int *)paper);
    }else if (_finger1 == 1){
        lcd.drawSprite(13,3,15,15,(int *)stone);
        }else if(_finger1 == 2){
            lcd.drawSprite(13,3,15,15,(int *)scissors);
            }
    if (_finger2 == 0){
    lcd.drawSprite(58,3,15,15,(int *)paper);
    }else if (_finger2 == 1){
        lcd.drawSprite(58,3,15,15,(int *)stone);
        }else if(_finger2 == 2){
            lcd.drawSprite(58,3,15,15,(int *)scissors);
            }
}

// run the finger-guess game
void Finger::run(N5110 &lcd,Gamepad &pad){
    c = 1; // the number to check whether game is over
    while(c){
      while(pad.check_event(Gamepad::START_PRESSED) == false){
          lcd.clear();
          if (pad.check_event(Gamepad::BACK_PRESSED) == true) {
          c = 0;
          break;
          }
          if ( pad.check_event(Gamepad::Y_PRESSED) == true && _finger1 >0) { //select the fingers
           _finger1--;
          }else if ( pad.check_event(Gamepad::A_PRESSED) == true && _finger1 < 2) {
           _finger1++;
           }
          if ( _finger2 < 2 ) {
           _finger2++;
          }else if ( _finger2 == 2) {
           _finger2 = 0;
           }
          draw(lcd,pad);
          lcd.refresh();
          wait(0.2);
      }
      // check who wins and add socres
      if (_finger1 == 0 && _finger2 ==1) {
        pad.tone(1500.0,0.5);
        _score1++;
        pad.leds_on();
        wait(1.0);
        pad.leds_off();
        }else if(_finger1 == 1 && _finger2 ==2) {
            pad.tone(1500.0,0.5); // speaker gives a sound
            _score1++; // add your score
            pad.leds_on(); // shine the LED
            wait(1.0);
            pad.leds_off();
            }else if(_finger1 == 2 && _finger2 ==0) {
                pad.tone(1500.0,0.5);
                _score1++;
                pad.leds_on();
                wait(1.0);
                pad.leds_off();
                }else if(_finger1 ==_finger2){
                    pad.tone(500.0,0.5);
                    wait(1.0);
                    }
                    else {
                      pad.tone(500.0,0.5);
                      _score2++; // add com score
                      wait(1.0);
                      }
    }
}