#include "Engine.h"

// nothing doing in the constructor and destructor
Engine::Engine()
{

}

Engine::~Engine()
{

}
// draw the pointer
int sprite[8][8] = {
    {0,0,0,1,1,0,0,0},
    {0,0,1,1,0,0,0,0},
    {0,1,1,0,0,0,0,0},
    {1,1,1,1,1,1,1,0},
    {1,1,1,1,1,1,1,0},
    {0,1,1,0,0,0,0,0},
    {0,0,1,1,0,0,0,0},
    {0,0,0,1,1,0,0,0},
};
// initialise the components of engine
void Engine::init() {
    direction = 0; //direction
    game = 0; // game number
    p = 1.0; // speed
    s = 1; // selection
}
// use Y and A make selection
int Engine::get_select(Gamepad &pad) {
     if ( pad.check_event(Gamepad::Y_PRESSED) == true && s >0) {
         s--;
     }else if ( pad.check_event(Gamepad::A_PRESSED) == true && s < 2) {
         s++;
     }
    return s;
}
// display of menu and wait user to select game, setting and game
void Engine::menu(Gamepad &pad, N5110 &lcd) {
   while(1){
   while ( pad.check_event(Gamepad::START_PRESSED) == false && pad.check_event(Gamepad::JOY_PRESSED) == false) {
      lcd.clear();
      s = get_select(pad); // get the selection
      lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
      lcd.drawRect(1,1,WIDTH-2,HEIGHT-2,FILL_TRANSPARENT);
      lcd.printString(" Press Y or A",2,1); // print the instruction
      lcd.printString(" Guess",4,2);
      lcd.printString(" Snake",4,3);
      lcd.printString(" Setting",4,4);
      if ( s == 1 ) {
          lcd.drawSprite(60,24,8,8,(int *)sprite);
          }else if ( s == 2) {
            lcd.drawSprite(60,32,8,8,(int *)sprite);
                  }else if( s == 0) {
                      lcd.drawSprite(60,16,8,8,(int *)sprite);
                      }
      lcd.refresh();
    }
     if ( s == 1 ){ // select the game
         select(pad,lcd);
         game = 0;
         break;
         }else if ( s == 2){
             setting(pad,lcd);
            }else if (s == 0){
                game = 1;
                break;
                }
    }
}
// use to change the brightness and contrast of LED
void Engine::setting(Gamepad &pad, N5110 &lcd) {
    while ( pad.check_event(Gamepad::BACK_PRESSED) == false ) {
    lcd.clear();
      int s = get_select(pad);
      float pot = pad.read_pot();
      lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
      lcd.drawRect(1,1,WIDTH-2,HEIGHT-2,FILL_TRANSPARENT);
      lcd.printString(" Light",4,3);
      lcd.printString(" Contrast",4,4);
      if ( s == 1 || s == 0){
         lcd.drawSprite(60,23,8,8,(int *)sprite);
         lcd.drawRect(12,10,60,10,FILL_TRANSPARENT);
         lcd.drawRect(12,10,60*pot,10,FILL_BLACK);
         lcd.setBrightness(pot);
         }else if ( s == 2){
            lcd.drawSprite(60,32,8,8,(int *)sprite);
            lcd.drawRect(12,10,60,10,FILL_TRANSPARENT);
            lcd.drawRect(12,10,60*pot,10,FILL_BLACK);
            lcd.setContrast(pot);
            }
       lcd.refresh();
    }
}

// simple splash screen of diffculty selection
void Engine::select(Gamepad &pad, N5110 &lcd) {
    while ( pad.check_event(Gamepad::START_PRESSED) == false && pad.check_event(Gamepad::JOY_PRESSED) == false) {
      lcd.clear();
      int s = get_select(pad);
      lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
      lcd.drawRect(1,1,WIDTH-2,HEIGHT-2,FILL_TRANSPARENT);
      lcd.printString(" Press Y or A",2,1);
      lcd.printString(" Easy",4,2);
      lcd.printString(" Normal",4,3);
      lcd.printString(" Hard",4,4);
      if ( s == 0) {
          lcd.drawSprite(63,15,8,8,(int *)sprite);
          p = 1.5; // change the speed
          }else if ( s == 1 ) {
              lcd.drawSprite(63,24,8,8,(int *)sprite);
              p = 1.0;
              }else if ( s == 2) {
                  lcd.drawSprite(63,32,8,8,(int *)sprite);
                  p = 0.5;
                  }
      lcd.refresh();
     }
}

// check the direction of the snake
int Engine::get_direction(Gamepad &pad) {
    if (pad.check_event(Gamepad::A_PRESSED) == true && direction != 3){
         direction = 1;
        } else if (pad.check_event(Gamepad::B_PRESSED) == true && direction != 2){
             direction = 0;
            } else if (pad.check_event(Gamepad::X_PRESSED) == true && direction != 0){
                direction = 2;
                } else if (pad.check_event(Gamepad::Y_PRESSED) == true && direction != 1){
                    direction = 3;
                    }
    // use the joystick can also control the snake
    if (pad.get_direction() == S && direction != 3){
         direction = 1;
        } else if (pad.get_direction() == E && direction != 2){
             direction = 0;
            } else if (pad.get_direction() == W && direction != 0){
                direction = 2;
                } else if (pad.get_direction() == N && direction != 1){
                    direction = 3;
                    }
    return direction;
    
}

// simple splash screen displayed on start-up
void Engine::welcome(Gamepad &pad, N5110 &lcd) {
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT); // draw the area of game
    lcd.drawRect(1,1,WIDTH-2,HEIGHT-2,FILL_TRANSPARENT);
    lcd.printString("###ULTRA###",10,1); // print the game name
    lcd.printString("#TWO IN ONE#",7,2);
    lcd.printString(" Qi Minghong ",4,3);
    lcd.printString(" Press Start ",4,4);
    lcd.refresh();
     
    // wait flashing LEDs with music until start button is pressed 
    while ( pad.check_event(Gamepad::START_PRESSED) == false && pad.check_event(Gamepad::JOY_PRESSED) == false) {
        pad.leds_on();
        pad.tone(659.0,0.15); // play some simple music
        wait(0.15);
        pad.leds_off();
        wait(0.15);
        pad.tone(659.0,0.15);
        pad.leds_on();
        wait(0.15);
        pad.leds_off();
        wait(0.15);
        pad.tone(587.0,0.15);
        pad.leds_on();
        wait(0.15);
        pad.leds_off();
        wait(0.15);
        pad.tone(659.0,0.15);
        pad.leds_on();
        wait(0.15);
        pad.leds_off();
        wait(0.15);
        pad.tone(784.0,0.15);
        pad.leds_on();
        wait(0.15);
        pad.leds_off();
        wait(0.15);
        pad.leds_on();
        pad.tone(659.0,0.15);
        wait(0.15);
        pad.leds_off();
        wait(0.15);
        pad.tone(659.0,0.15);
        pad.leds_on();
        wait(0.15);
        pad.leds_off();
        wait(0.15);

    }
}


// simple splash screen displayed on pasue
void Engine::pause(Gamepad &pad, N5110 &lcd) {
    pad.tone(500.0,0.5);
    lcd.drawRect(22,13,40,14,FILL_TRANSPARENT);
    lcd.printString("PAUSE",28,2);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::BACK_PRESSED) == false && pad.check_event(Gamepad::JOY_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}

// simple splash screen of game over
void Engine::gameover(Gamepad &pad, N5110 &lcd, int score,int hscore) {
    pad.tone(1000.0,0.5);
    wait(0.1);
    pad.tone(500.0,0.5);
    wait(0.1);
    pad.tone(300.0,0.5);
    wait(0.1);
    pad.tone(100.0,0.5);
    wait(0.1);
    lcd.clear();
    pad.init();
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    lcd.drawRect(1,1,WIDTH-2,HEIGHT-2,FILL_TRANSPARENT);
    lcd.printString("  GAME OVER ",4,1); 
     // we need an array of chars to store the message
    char buffer[14];  // max screen witdth is 14
    // print message to buffer
    sprintf(buffer,"  Score : %d ",score);
    lcd.printString(buffer,2,2);
    char hbuffer[14];  
    sprintf(hbuffer,"Record : %d",hscore);
    lcd.printString(hbuffer,8,3);
    lcd.printString(" press back",8,4);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::BACK_PRESSED) == false && pad.check_event(Gamepad::JOY_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 
}