#include "mbed.h"
#include "XNucleo53L0A1.h"
#include <stdio.h>

#define VL53L0_I2C_SDA   D14 
#define VL53L0_I2C_SCL   D15 

static XNucleo53L0A1 *board=NULL;


int main()
{
    
    DevI2C *device_i2c = new DevI2C(VL53L0_I2C_SDA, VL53L0_I2C_SCL);
    
    /* creates the 53L0A1 expansion board singleton obj */
    board = XNucleo53L0A1::instance(device_i2c, A2, D8, D2);

    /* init the 53L0A1 expansion board with default values */
    status = board->init_board();
    if (status) {
        printf("Failed to init board!\r\n");
        return 0;
    }

   while (1) {
        status = board->sensor_centre->get_distance(&distance);
        if (status == VL53L0X_ERROR_NONE) {
           printf("Distance : %ld\r\n", distance);
        }
   }
}
