#include <mbed.h>
#include <EthernetInterface.h>
#include "FXOS8700Q.h"

int main(int argc, char** argv) {
    
    int16_t X, Y, Z;
    
    Serial pc(USBTX, USBRX);
    pc.baud(115200);
    
    I2C i2c(PTE25,PTE24);
    FXOS8700QAccelerometer acc(i2c, FXOS8700CQ_SLAVE_ADDR1);
    acc.enable();
    
    pc.printf("Welcome to the FRDM + Bipio\r\n");
    
    EthernetInterface eth;
    eth.init();
    eth.connect();
    
    pc.printf("IP Addr: %s\r\n", eth.getIPAddress());
    
    while(true) {
      pc.printf("Polling x,y,z\r\n");
      TCPSocketConnection sock;
      sock.connect("david.api.shipiot.net",80);
      
      acc.getX(X);   
      acc.getY(Y);   
      acc.getZ(Z); 
      
      char http_request[] =     "POST /bip/http/accel HTTP/1.1\r\n"
                                "Host: username.api.shipiot.net\r\n"            // change the username to your username
                                "Content-Type: application/json\r\n"
                                "Content-Length: %d\r\n"
                                "Authorization: Basic dGVzdDp0ZXN0\r\n"         // change the dGVzdDp0ZXN0 to your auth token
                                "\r\n"
                                "%s";
                                
       char buffer[255];
       char json[] = "{ \"x\": %d, \"y\": %d, \"z\": %d }";
       
       sprintf(buffer,json,X,Y,Z);
       
       char request[512];
       
       sprintf(request,http_request,strlen(buffer), buffer);
       
       sock.send_all(request, strlen(request));
       
       pc.printf(buffer);
       
       sock.close();
       
       wait(1.0);              
        
    }
    // should never get here...
}